block('b-edit-group').mod('type', 'mobile-content')(

    addMix()(function() {
        return {
            block: 'i-glue',
            js: {
                modelParams: {
                    name: this.groupModelName,
                    id: this.groupId
                }
            }
        };
    }),

    mode('setModel')(function() {
        var group = this.ctx.group;

        if (!group.group_name) group.group_name = iget2('b-edit-group', 'novaya-gruppa-obyavleniy', 'Новая группа объявлений');

        this.campaign = this.ctx.campaign;
        this.groupModelName = 'b-edit-group_type_mobile-content';
        this.group = group;
        this.isSingleGroup = this.ctx.isSingleGroup;
        this.firstBanner = this.ctx.firstBanner;
        this.prevBanner = this.ctx.prevBanner;
        this.errors = group.errors || {};
        this.groupIndex = this.ctx.groupIndex;
        this.groupId = this.group.modelId;
        this.mobileAppTrackerHref = u._.get(this.campaign, 'selected_mobile_app.trackers[0].url', '');
    }),

    js()(function() {
        return {
            modelName: this.groupModelName,
            modelId: this.groupId,
            cid: this.data.campaign.cid,
            newBannerData: {
                hasHeaderActions: false,
                withVCard: this.group.withVCard,
                canEditDomain: this.ctx.canEditDomain,
                isCopyGroup: this.ctx.isCopyGroup,
                isNewGroup: this.ctx.isNewGroup,
                isSingleGroup: this.ctx.isSingleGroup,
                mobileAppTrackerHref: this.mobileAppTrackerHref
            },
            isRmpCpcVideoEnabled: !!(this.data.features_enabled_for_client || {})
                .mobile_content_cpc_video_allowed,
            isSingleGroup: this.group.isSingleGroup,
            mobileAppTrackerHref: this.mobileAppTrackerHref
        };
    }),

    content()(function() {
        var data = this.data,
            group = this.group,
            campaign = this.campaign,
            selectedMobileApp = group.selected_mobile_app || campaign.selected_mobile_app || {},
            isCampWithApp = !!Object.keys(selectedMobileApp).length,
            sortedPhrases = group.sorted && group.sorted.phrases,
            showSuggestions = data.campaign.groups.length === 1,
            availableCount = data.CONSTS.DEFAULT_CREATIVE_COUNT_LIMIT - 1 * group.banners_quantity,
            hasPhrases = sortedPhrases &&
            (sortedPhrases.declined.length ||
                sortedPhrases.low_ctr.length ||
                sortedPhrases.context.length ||
                sortedPhrases.active.length ||
                sortedPhrases.suspended.length),
            groupContentBanners = [
                {
                    block: 'b-edit-group',
                    elem: 'selected-app',
                    app: selectedMobileApp
                },
                {
                    block: 'b-edit-group',
                    elem: 'rename-group',
                    headerType: 'mobile-content',
                    modelName: 'dm-mobile-content-group'
                },
                {
                    block: 'b-edit-group',
                    elem: 'store-href',
                    hidden: 'yes',
                    readOnly: !this.isNewGroup,
                    modelName: 'dm-mobile-content-group'
                },
                group.banners.map(function(banner, index) {
                    return {
                        block: 'b-edit-banner2',
                        mods: {
                            type: 'mobile-content'
                        },
                        banner: banner,
                        urlLengthLimit: u.consts('MAX_URL_LENGTH'),
                        //если новый, не первый баннер в группе
                        canDelete: banner.bid == 0 && index > 0,
                        index: index,
                        campaign: data.campaign,
                        new_banner: data.new_banner,
                        isRmpCpcVideoEnabled: !!(data.features_enabled_for_client || {})
                            .mobile_content_cpc_video_allowed,
                        hasHeaderActions: true,
                        group: group,
                        withVCard: true,
                        canEditDomain: this.ctx.canEditDomain,
                        isCopyGroup: group.isCopyGroup,
                        isSingleGroup: group.isSingleGroup,
                        mobileAppTrackerHref: this.mobileAppTrackerHref,
                        mixes: {
                            row: [{
                                block: 'b-edit-group',
                                elem: 'banner-row'
                            }]
                        },
                        availableBannerCount: availableCount
                    };
                }, this)
            ],

            isLimitRateRequired = group.has_general_limit_price && group.isNewGroup,  // has_general_limit_price - стратегия ручная или нет

            groupPropertiesLabel = {
                block: 'b-edit-group',
                attrs: {
                    id: 'Group-properties-' + this.group.modelId
                },
                elem: 'group-properties',
                content: [
                    iget2('b-edit-group', 'nastroyki-na-vsyu-gruppu', 'Настройки на всю группу'),
                    {
                        block: 'icon',
                        mods: { type: 'arrow', direction: 'bottom' },
                        attrs: { style: 'width: 16px; height: 16px;' },
                        mix: { block: 'b-edit-group', elem: 'expander-icon' }
                    }
                ]
            },
            groupContentBannerGroup = [
                {
                    mixes: {
                        label: [{
                            block: 'b-edit-group',
                            elem: 'label',
                            elemMods: { expandable: 'yes' }
                        }]
                    },
                    label: groupPropertiesLabel,
                    control: false
                },
                {
                    block: 'b-edit-group',
                    elem: 'relevance-match',
                    modelName: 'dm-mobile-content-group',
                    strategy: data.campaign.strategy
                },
                hasPhrases && {
                    block: 'b-edit-group',
                    elem: 'phrases',
                    modelName: 'dm-mobile-content-group',
                    campaignModelName: 'dm-mobile-content-campaign'
                },
                {
                    block: 'b-edit-group',
                    elem: 'new-phrases',
                    showSuggestions: showSuggestions,
                    modelName: 'dm-mobile-content-group',
                    campaignModelName: 'dm-mobile-content-campaign'
                },
                {
                    block: 'b-edit-group',
                    elem: 'word-suggestions',
                    group: group,
                    errors: !hasPhrases && this.errors.phrases || [],
                    showSuggestions: showSuggestions,
                    modelName: 'dm-mobile-content-group'
                },
                {
                    block: 'b-edit-group',
                    elem: 'minus-words',
                    modelName: 'dm-mobile-content-group'
                },
                {
                    block: 'b-edit-group',
                    elem: 'retargeting'
                },
                {
                    block: 'b-edit-group',
                    elem: 'interests',
                    modelName: 'dm-mobile-content-group'
                },
                {
                    block: 'b-edit-group',
                    elem: 'mobile-content-os'
                },
                {
                    block: 'b-edit-group',
                    elem: 'device-type'
                },
                {
                    block: 'b-edit-group',
                    elem: 'network'
                },
                {
                    block: 'b-edit-group',
                    elem: 'regions',
                    parentModelName: 'dm-mobile-content-group'
                },
                {
                    elem: 'adjustment-rates',
                    modelData: group.hierarchicalMultipliers,
                    tabsHash: u['b-adjustment-rates-popup'].getTabsHash({
                        hasRetargetingConditions: u.retargeting.hasRetargetingConditions(
                            this.data.all_retargeting_conditions,
                            'metrika_goals'
                        ),
                        demography: true,
                        retargeting: true,
                        performanceTGO: false
                    })
                },
                this.data.tags_allowed === 'Yes' && {
                    block: 'b-edit-group',
                    elem: 'tags',
                    tagsList: this.group.tags,
                    modelName: 'dm-mobile-content-group',
                    campaignName: 'dm-mobile-content-campaign'
                }
            ];

        return [
            applyNext(),
            apply('editLayout', {
                group: group,
                mix: {
                    block: 'b-edit-group',
                    elem: 'banners-wrapper'
                },
                groupContent: groupContentBanners
            }),
            apply('editLayout', {
                group: group,
                groupContent: [{
                    block: 'b-edit-group',
                    elem: 'add-banner-button',
                    availableToCreateBannersCount: u.consts('DEFAULT_CREATIVE_COUNT_LIMIT') - group.banners_quantity,
                    mainTitle: iget2('b-edit-group', 'dobavit-obyavlenie', 'Добавить объявление'),
                    pluralTitles: [iget2('b-edit-group', 'obyavlenie-111', 'объявление'), iget2('b-edit-group', 'obyavleniya', 'объявления'), iget2('b-edit-group', 'obyavleniy', 'объявлений')]
                }]
            }),
            group.has_general_limit_price && apply('editLayout', {
                group: group,
                groupContent: [{
                    block: 'b-edit-group',
                    elem: 'limit-rate',
                    campDMParams: {
                        name: 'dm-mobile-content-campaign'
                    },
                    modelParams: {
                        name: 'dm-mobile-content-group',
                        id: group.modelId
                    },
                    isLimitRateRequired: isLimitRateRequired,
                    doShowLimitRateOutside: true, // Параметр определяет отображение ставок внутри блока настроек или вне оного
                    labelText: iget2('b-edit-group', 'maximal-bid', 'Максимальная ставка'),
                    currency: data.campaign.currency
                }]
            }),
            apply('editLayout', {
                mix: [
                    {
                        block: 'b-edit-group',
                        elem: 'grey-wrapper'
                    },
                    {
                        block: 'b-edit-group',
                        elem: 'expandable'
                    }
                ],
                group: group,
                groupContent: groupContentBannerGroup
            })
        ];
    }),

    elem('group-data').content()(function() {
        var group = this.group;

        return {
            block: 'i-model-aggregator',
            content: [
                applyNext(),
                {
                    block: 'i-model',
                    modelParams: {
                        name: 'm-adjustment-rates',
                        id: group.modelId,
                        data: group.hierarchicalMultipliers
                    }
                },
                group.relevance_match && group.relevance_match.length > 0 && {
                    block: 'i-model',
                    modelParams: {
                        name: 'm-relevance-match',
                        parentName: 'dm-mobile-content-group',
                        id: this.groupId,
                        parentId: this.groupId,
                        data: applyCtx({
                            block: 'm-relevance-match',
                            group: group,
                            // автотаргетинг всегда 1 на группу
                            relevance_match: group.relevance_match[0]
                        })
                    }
                }
            ]
        };
    })
);
