/**
 * Блок редактирования группы объявлений
 * @param {Object} this.params js-параметры блока
 * @param {String} this.params.modelName
 * @param {String} this.params.modelId
 * @param {String} this.params.cid
 * @param {Object} this.params.newBannerData
 * @param {Boolean} this.params.withMobile
 */
BEM.DOM.decl({ block: 'b-edit-group', modName: 'type', modVal: 'mobile-content' }, {

    onSetMod: {
        js: function() {
            this.__base.apply(this, arguments);

            this._initGeneralLimitPrice(this.model.getDM()['dm-mobile-content-group']);
            this._initGroupPropertiesEvent();
        }
    },

    /**
     * Связано с DIRECT-83680
     * Нужно передавать параметры отдельно через дефолтный набор,
     * потому что дата модель группы удаляет поле href при копировании из предыдущего
     *
     * Реакция на нажатие кнопки добавления нового баннера
     */
    _onBannerAddRequest: function() {
        var bannerData = {
            href: this._getRecentHref()
        };

        this._addBanner(
            this._getNewBannerModel(bannerData)
        );
    },

    /**
     * Возвращает href последнего баннера из тех,
     * в котором оно указано (или исходное значение).
     * @return {String}
     */
    _getRecentHref: function() {
        var defaultHref = this.params.mobileAppTrackerHref,
            hrefs = this.model.getBanners()
                .map(function(banner) { return banner.get('href'); })
                .filter(Boolean);

        return u._.last(hrefs) || defaultHref;
    },

    /**
     * @override {b-edit-group}
     */
    _additionalInit: function() {
        this.model.init();

        this.findBlocksOn('show-phrases-btn', 'button').forEach(function(button) {
            this._getSubscriptionManager().on(button, 'click', this._showPhrases, this);
        }, this);

        this._initRetargeting();

        var tumbler = this.findBlockInside('relevance-match-tumbler', 'tumbler'),
            sbMan = this._getSubscriptionManager();

        if (tumbler) {
            sbMan.on(tumbler, 'change', function(e, data) {
                var isActive = data.value === 'true';

                this.model.set('has_relevance_match', isActive);
            }, this);
        }
    },

    /**
     * @override {b-edit-group}
     */
    _getEditBlockBemjson: function(bannerModel) {
        var bannerData = bannerModel.provideData();

        bannerData.mobileAppTrackerHref = this.params.mobileAppTrackerHref;

        return u._.extend({}, this.params.newBannerData, {
            block: 'b-edit-banner2',
            mods: { type: 'mobile-content' },
            canDelete: bannerData.isNewBanner && this.model.get('bannerIds').length > 1,
            hasHeaderActions: true,
            urlLengthLimit: u.consts('MAX_URL_LENGTH'),
            banner: bannerData,
            isRmpCpcVideoEnabled: this.params.isRmpCpcVideoEnabled,
            campaign: this.model.getDM()['dm-mobile-content-group'].getCampaignModel().toJSON(),
            group: this.model.getGroupData(),
            noModelData: true,
            withVCard: true,
            availableBannerCount: this._getAvailableToCreateBannersCount()
        });
    },

    /**
     * @override {b-edit-group}
     */
    _getAvailableToCreateBannersCount: function() {
        return this.model.get('bannersLeft');
    },

    /**
     * @override {b-edit-group}
     */
    _updateCountInBlocks: function(available) {
        this.findBlocksInside('banner', 'b-edit-banner2')
            .forEach(function(banner) {
                banner.updateAvailableBannerCount(available);
            });
    },

    /**
     * Показываем попап с фразами для текущего баннера
     * @param {event} e
     */
    _showPhrases: function(e) {
        var phrases = e.block.params.phrases,
            phrasesPopup = this.__self._getPhrasesPopup(),
            popupContent = phrases.map(function(phrase) {
                return {
                    block: 'b-edit-group',
                    elem: 'show-phrases-phrase',
                    content: phrase
                };
            });

        phrasesPopup.isShown() ?
            phrasesPopup.hide() :
            phrasesPopup.setContent($(BEMHTML.apply(popupContent))).show(e.block);
    },

    /**
     * Подписываемся на click на Label, раскрываем настройки на всю группу при наличии ошибок
     * @private
     */
    _initGroupPropertiesEvent: function() {
        var elem = this.findElem('group-properties');

        if (elem) {
            this.bindTo('group-properties', 'click', function() {
                this.toggleMod(this.elem('expandable'), 'open', 'yes', '');
            });

            this.channel('multiedit-errors').on('invalid', function(e, data) {
                if (data.groupsErrors.length) {
                    this.setMod(this.elem('expandable'), 'open', 'yes');
                }
            }, this);
        }
    }
}, {
    /**
     * Экземпляр попапа со списком фраз.
     */
    _phrasesPopup: null,

    /**
     * Возвращает экземпляр блока 'popup' со списком фраз
     * если его нет - создаёт и добавляет
     * @returns {BEM.DOM}
     * @private
     */
    _getPhrasesPopup: function() {
        if (this._phrasesPopup) return this._phrasesPopup;

        var popup = $(BEMHTML.apply({
            block: 'popup',
            js: true,
            mods: { 'has-close': 'yes' },
            content: [
                { elem: 'tail' },
                {
                    elem: 'content',
                    content: []
                }
            ]
        }));

        return this._phrasesPopup = popup.bem('popup');
    }
});
