BEM.MODEL.decl({ name: 'b-edit-group_type_mobile-content', baseModel: 'vm-sync-dm2' }, {

    /**
     * декларация DM модели
     */
    _dmDecl: {
        type: 'object',
        calculate: function() {
            return {
                'dm-mobile-content-group': {
                    name: 'dm-mobile-content-group',
                    id: this.id
                }
            };
        }
    },

    // минимальная версия приложения
    min_os_version: 'string',

    // Id модели и группы
    modelId: 'string',

    // Тип устройства для таргетирования
    deviceType: {
        type: 'string',
        preprocess: function(val) {
            return val && u._.isArray(val) ? val.join(',') : val;
        }
    },

    // Тип связи для таргетирования
    network: {
        type: 'string',
        preprocess: function(val) {
            return val && u._.isArray(val) ? val.join(',') : val;
        }
    },

    bannerIds: 'array',

    unshownBannersCount: 'number',

    bannersLeft: {
        type: 'number',
        calculate: function() {
            // учитываем баннеры в других статусах, которые не отображаются
            // например баннеры на модерации не отображаются, если открывать редактирование со вкладки "активные"
            // https://st.yandex-team.ru/DIRECT-59687
            return u.consts('DEFAULT_CREATIVE_COUNT_LIMIT') -
                this.get('unshownBannersCount') -
                this.get('bannerIds').length
        },
        dependsFrom: ['bannerIds']
    },

    retargetingsIds: 'array',

    has_relevance_match: {
        type: 'boolean',
        default: false
    }
}, {

    init: function() {
        var dm = this.getDM()['dm-mobile-content-group'];

        this.__base.apply(this, arguments);

        // todo@ddos move it to bemtree?
        this.set('bannerIds', dm.getBanners().map(function(bannerModel) {
            return bannerModel.get('modelId');
        }));

        this.set('unshownBannersCount', dm.get('banners_quantity') - this.get('bannerIds').length);

        dm.on('banners', 'add', function(e, data) {
            this.get('bannerIds').splice(data.index, 0, data.model.get('modelId'));
        }, this);

        dm.on('banners', 'remove', function(e, data) {
            this.get('bannerIds').splice(data.index, 1);
        }, this);

        this.set('deviceType', dm.get('device_type_targeting'));
        dm.on('device_type_targeting', 'change', function() {
            this.set('deviceType', dm.get('device_type_targeting'));
        }, this);
        this.on('deviceType', 'change', function() {
            dm.set('device_type_targeting', this.get('deviceType').split(','));
        }, this);

        this.set('network', dm.get('network_targeting'));
        dm.on('network_targeting', 'change', function() {
            this.set('network', dm.get('network_targeting'));
        }, this);
        this.on('network', 'change', function() {
            dm.set('network_targeting', this.get('network').split(','));
        }, this);

        this.set('min_os_version', dm.get('min_os_version'));
        dm.on('min_os_version', 'change', function() {
            this.set('min_os_version', dm.get('min_os_version'));
        }, this);
        this.on('min_os_version', 'change', function() {
            dm.set('min_os_version', this.get('min_os_version'));
        }, this);

        this.set('retargetingsIds', dm.get('retargetingsIds'));

        this.on('retargetingsIds', 'change',function() {
            dm.set('retargetingsIds', this.get('retargetingsIds'));
        });

        this.set('has_relevance_match', dm.get('has_relevance_match'));
        this.on('has_relevance_match', 'change',function() {
            dm.set('has_relevance_match', this.get('has_relevance_match'));
        });
    },

    /**
     * Возвращает данные группы
     * @returns {Object}
     */
    getGroupData: function() {
        return this.getDM()['dm-mobile-content-group'].provideData();
    },

    /**
     * Добавляет баннер в группу
     */
    addBanner: function(defaults) {
        return this.getDM()['dm-mobile-content-group'].addBanner(defaults);
    },

    /**
     * Удаляет баннер из группы
     */
    removeBanner: function(bannerId) {
        return this.getDM()['dm-mobile-content-group'].removeBanner(bannerId);
    },

    /**
     * Возвращает модели баннеров
     * @returns {Array}
     */
    getBanners: function() {
        return this.getDM()['dm-mobile-content-group'].getBanners();
    },

    /**
     * Возвращает модель баннера по идентификатору
     * @param {String|Number} id
     */
    getBannerData: function(id) {
        return this.getDM()['dm-mobile-content-group'].getBannerByModelId(id).provideData();
    },

    /**
     * Возвращает данные, необходимые для отрисовки ошибок в хедере
     * @returns {Object}
     */
    toJSONForErrors: function() {
        var res = {};

        ['isCopyGroup', 'newGroupIndex', 'isNewGroup', 'isSingleGroup', 'adgroup_id', 'modelId']
            .forEach(function(name) {
                res[name] = this.get(name);
            }, this);

        return res;
    }
});
