block('b-edit-group').mod('type', 'text-full')(

    elem('group-data').content()(function() {
        var group = this.group;

        return {
            block: 'i-model-aggregator',
            content: [
                applyNext(),
                {
                    block: 'i-model',
                    modelParams: {
                        name: 'm-adjustment-rates',
                        id: group.modelId,
                        data: group.hierarchicalMultipliers
                    }
                },
                group.relevance_match && group.relevance_match.length > 0 && {
                    block: 'i-model',
                    modelParams: {
                        name: 'm-relevance-match',
                        parentName: this.groupModelName,
                        id: this.groupId,
                        parentId: this.groupId,
                        data: applyCtx({
                            block: 'm-relevance-match',
                            group: group,
                            // автотаргетинг всегда 1 на группу
                            relevance_match: group.relevance_match[0]
                        })
                    }
                }
            ]
        };
    }),

    content()(function() {
        var data = this.data,
            campaign = this.campaign,
            group = this.group,
            availableCount = data.CONSTS.DEFAULT_CREATIVE_COUNT_LIMIT - 1 * group.banners_quantity,
            sortedPhrases = group.sorted.phrases,
            //блок с подсказками показываем только если мы на редактировании одной группы
            showSuggestions = this.data.campaign.groups.length == 1,
            hasPhrases = sortedPhrases &&
            (sortedPhrases.declined.length ||
                sortedPhrases.low_ctr.length ||
                sortedPhrases.context.length ||
                sortedPhrases.suspended.length ||
                sortedPhrases.active.length),
            groupContentBanners = [
                {
                    block: 'b-edit-group',
                    elem: 'rename-group'
                },
                group.banners.map(function(banner, index) {
                    banner.status_click_track = campaign.status_click_track;

                    return {
                        block: 'b-edit-banner2',
                        mix: [{
                            block: 'b-edit-group',
                            elem: 'banner-row',
                            elemMods: {
                                'banner-id': banner.modelId
                            }
                        }],
                        mods: {
                            type: 'text',
                            'with-vcard': 'yes'
                        },
                        banner: banner,
                        urlLengthLimit: u.consts('MAX_URL_LENGTH'),
                        //если новый, не первый баннер в группе
                        canDelete: banner.bid == 0 && index > 0,
                        //common: data.common,
                        index: index,
                        campaign: data.campaign,
                        new_banner: data.new_banner,
                        hasHeaderActions: true,
                        group: group,
                        withVCard: true,
                        availableBannerCount: availableCount,
                        canEditDomain: this.ctx.canEditDomain,
                        isCopyGroup: group.isCopyGroup,
                        isSingleGroup: group.isSingleGroup,
                        withMobile: true,
                        clientId: data.campaign.ClientID,
                        isTurboLandingEnabled: data.is_featureTurboLandingEnabled,
                        promoCodeDomains: data.promocode_domains,
                        isNewGroup: !!data.new_group
                    };
                }, this)
            ],
            groupContentBannerGroup = [
                {
                    control: {
                        block: 'b-edit-group',
                        attrs: {
                            id: 'Group-properties-' + this.group.modelId
                        },
                        elem: 'group-properties',
                        content: iget2('b-edit-group', 'nastroyki-na-vsyu-gruppu', 'Настройки на всю группу')
                    }
                },
                {
                    block: 'b-edit-group',
                    elem: 'relevance-match',
                    strategy: data.campaign.strategy
                },
                hasPhrases && {
                    block: 'b-edit-group',
                    elem: 'phrases'
                },
                {
                    block: 'b-edit-group',
                    elem: 'new-phrases',
                    showSuggestions: showSuggestions
                },
                {
                    block: 'b-edit-group',
                    elem: 'word-suggestions',
                    group: group,
                    errors: !hasPhrases && this.errors.phrases || [],
                    showSuggestions: showSuggestions
                },
                {
                    block: 'b-edit-group',
                    elem: 'minus-words'
                },
                {
                    block: 'b-edit-group',
                    elem: 'retargeting'
                },
                {
                    block: 'b-edit-group',
                    elem: 'regions'
                },
                group.has_general_limit_price && {
                    block: 'b-edit-group',
                    elem: 'limit-rate',
                    campDMParams: {
                        name: 'm-campaign'
                    },
                    modelParams: {
                        name: this.groupModelName,
                        id: group.modelId
                    },
                    currency: data.campaign.currency
                },
                {
                    elem: 'adjustment-rates',
                    modelData: group.hierarchicalMultipliers,
                    tabsHash: u['b-adjustment-rates-popup'].getTabsHash({
                        hasRetargetingConditions: u.retargeting.hasRetargetingConditions(
                            this.data.all_retargeting_conditions,
                            'metrika_goals'
                        ),
                        demography: true,
                        mobile: true,
                        devices: hasEnabledFeatures('cpc_device_modifiers'),
                        video: true,
                        retargeting: true,
                        performanceTGO: false
                    })
                },
                this.data.tags_allowed == 'Yes' && {
                    block: 'b-edit-group',
                    elem: 'tags'
                }
            ];

        return [
            applyNext(),
            apply('editLayout',{
                group: group,
                mix: {
                    block: 'b-edit-group',
                    elem: 'banners-wrapper'
                },
                groupContent: groupContentBanners
            }),
            apply('editLayout', {
                group: group,
                groupContent: [{
                    block: 'b-edit-group',
                    elem: 'add-banner-button',
                    availableToCreateBannersCount: u.consts('DEFAULT_CREATIVE_COUNT_LIMIT') - group.banners_quantity,
                    mainTitle: iget2('b-edit-group', 'dobavit-obyavlenie', 'Добавить объявление'),
                    pluralTitles: [iget2('b-edit-group', 'obyavlenie-111', 'объявление'), iget2('b-edit-group', 'obyavleniya', 'объявления'), iget2('b-edit-group', 'obyavleniy', 'объявлений')]
                }]
            }),
            apply('editLayout', {
                mix: {
                    block: 'b-edit-group',
                    elem: 'grey-wrapper'
                },
                group: group,
                groupContent: groupContentBannerGroup
            })
        ];
    })
);
