BEM.DOM.decl({ name: 'b-edit-group', modName: 'type', modVal: 'text-full' }, {

    onSetMod: {
        js: function() {
            var login = this.params.login,
                cid = this.params.cid,
                isNewGroup = this.params.isNewGroup;

            this.__base.apply(this, arguments);

            this._initGeneralLimitPrice(this.model);

            // не загружаем рекомендацию для новых групп
            if (!isNewGroup) {
                u['b-turbo-landings-selector'].getTurboRecommendation(login, cid, this.model);
            }
        }
    },

    /**
     * @override {b-edit-group}
     */
    _additionalInit: function() {
        this.__base.apply(this, arguments);

        var tumbler = this.findBlockInside('relevance-match-tumbler', 'tumbler'),
            sbMan = this._getSubscriptionManager();

        if (tumbler) {
            sbMan.on(tumbler, 'change', function(e, data) {
                var isActive = data.value === 'true';

                this.model.set('has_relevance_match', isActive);
            }, this);
        }
    },

    /**
     * @override {b-edit-group}
     */
    _getNewBannerModel: function(defaults) {
        var newBannerData = u._.extend({}, defaults);

        if (this.params.hasMediaResources && this.params.isAutoVideoOn) {
            this._mediaExtensionsDataProvider = this._mediaExtensionsDataProvider ||
                BEM.create('i-banner-media-extensions-data', { resources: this._bannerMediaResources });

            // для новых баннеров видео по умолчанию уже создано
            u._.extend(newBannerData, {
                video_resources: this._mediaExtensionsDataProvider.getVideo()
            });
        }

        return this.model.addBanner(newBannerData);
    },

    /**
     * @override {b-edit-group}
     */
    _onBeforeBannerAdd: function(bannerModel) {
        this.model.set('banners_quantity', this.model.get('banners_quantity') + 1);
    },

    /**
     * @override {b-edit-group}
     */
    _onBeforeBannerRemove: function(bannerId) {
        this.model.set('banners_quantity', this.model.get('banners_quantity') - 1);
    },

    /**
     * @override {b-edit-group}
     */
    _getAvailableToCreateBannersCount: function() {
        return u.consts('DEFAULT_CREATIVE_COUNT_LIMIT') - this.model.get('banners_quantity');
    },

    /**
     * @override {b-edit-group}
     */
    _updateCountInBlocks: function(available) {
        this._banners
            .forEach(function(banner) {
                banner.updateAvailableBannerCount(available);
            });
    },

    /**
     * @override {b-edit-group}
     */
    _getEditBlockBemjson: function(bannerModel) {
        var bannerData = bannerModel.provideData();

        return u._.extend({}, this.params.newBannerData, {
            block: 'b-edit-banner2',
            mods: { type: 'text' },
            canDelete: true,
            urlLengthLimit: u.consts('MAX_URL_LENGTH'),
            banner: bannerData,
            group: u._.extend(this.model.provideData(), { modelId: this.model.id }),
            campaign: this.model.getCampaignModel().toJSON(),
            noModelData: true,
            modelParams: {
                name: bannerModel.name,
                id: bannerModel.id,
                parentModel: this.model
            },
            withMobile: this.params.withMobile,
            availableBannerCount: this._getAvailableToCreateBannersCount(),
            errorPath: this._errorPathBuilder(bannerData.newBannerIndex),
            clientId: this.params.clientId,
            isTurboLandingEnabled: this.params.isTurboLandingEnabled
        });
    }
});
