BEM.DOM.decl({ name: 'b-edit-groups-error-header', modName: 'group-type', modVal: 'mobile-content' }, {

    /**
     * Обработчик ошибок валидации модели
     * @param {Event} event событие
     * @param {Object} data информация об ошибке
     * @param {Array} data.invalidGroupsData список невалидных групп
     */
    onInvalidMultiedit: function(event, data) {
        var groups = BEM.MODEL.get('dm-mobile-content-group'),
            bannersLength = 0,
            hasAllErrors;

        groups.forEach(function(group) {
            bannersLength = bannersLength + group.get('banners').length;
        });

        hasAllErrors = data.groupsErrors.length == groups.length &&
            data.titleErrors.length == groups.length &&
            data.bannersErrors.length == bannersLength;

        BEM.DOM.update(this.elem('errors-list-wrapper'), BEMHTML.apply({
            block: 'b-edit-groups-error-header',
            elem: 'errors-list',
            titleErrors: data.titleErrors,
            groupsErrors: data.groupsErrors,
            bannersErrors: data.bannersErrors,
            hasAllErrors: hasAllErrors
        }));

        this.setMod('visible', 'yes');

        BEM.DOM.win.scrollTop(0);
    }
});
