block('b-edit-groups-error-header')(

    def()(function() {
        if (this.mods.mode == 'static') return applyNext();

        var bannersErrors = u._.flatten(this.ctx.groups.filter(function(group) {
                return group.errors && group.errors.banners;
            }).map(function(group) {
                return group.banners.filter(function(banner) {
                    return banner.errors;
                }).map(function(banner) {
                    return {
                        banner: banner,
                        group: group
                    };
                }) || []
            })) || [],

            groupsErrors = this.ctx.groups.filter(function(group) {
                var errors = group.errors,
                    size = u._.size(errors);

                errors.banners && (size = size - 1);
                errors.group_name && (size = size - 1);

                return size > 0;
            }) || [],

            titleErrors = this.ctx.groups.filter(function(group) {
                return !!group.errors.group_name;
            }) || [],

            groupsLength = this.ctx.groups.length,
            bannersLength = u.flatten(this.ctx.groups.map(function(group) {
                return group.banners;
            })).length,

            hasAllErrors = groupsErrors.length == groupsLength &&
                titleErrors.length == groupsLength &&
                bannersErrors.length == bannersLength;

        return applyNext({
            bannersErrors: bannersErrors,
            groupsErrors: groupsErrors,
            titleErrors: titleErrors,
            hasAllErrors: hasAllErrors
        })
    }),

    js()(function() {
        return { modelName: this.ctx.modelName || 'm-group' };
    }),

    content()(function() {
        return [
            {
                elem: 'message',
                content: [
                    {
                        block: 'icon',
                        mods: { 'size-16': 'alert' },
                        mix: [{
                            block: 'b-form-errors-header',
                            elem: 'notice'
                        }]
                    },
                    iget2(
                        'b-edit-groups-error-header',
                        'pozhaluysta-zapolnite-pravilno-neobhodimye',
                        'Пожалуйста, заполните правильно необходимые поля'
                    )
                ]
            },
            {
                elem: 'errors-list-wrapper',
                content: {
                    elem: 'errors-list',

                    bannersErrors: this.bannersErrors,

                    groupsErrors: this.groupsErrors,

                    titleErrors: this.titleErrors,

                    hasAllErrors: this.hasAllErrors,

                    genericErrors: this.genericErrors || []
                }
            }
        ];
    }),

    elem('errors-list').content()(function() {
        return this.ctx.hasAllErrors ?
            '' :
            [
                !!(this.ctx.groupsErrors.length) && {
                    block: 'b-edit-groups-error-header',
                    elem: 'sub-message',
                    content: [
                        iget2('b-edit-groups-error-header', 'oshibki-v-nastroykah-grupp', 'Ошибки в настройках групп') + ':',
                        this.ctx.groupsErrors.map(function(group, i) {
                            return [
                                i == 0 ? ' ' : ', ',
                                {
                                    elem: 'group-link',
                                    elemMods: { type: 'properties' },
                                    group: group,
                                    url: '#Group-properties-' + group.modelId
                                }
                            ];
                        }, this)
                    ]
                },

                !!((this.ctx.genericErrors || []).length) && {
                    block: 'b-edit-groups-error-header',
                    elem: 'sub-message',
                    content: [
                        this.ctx.genericErrors.map(function(error, i) {
                            return {
                                elem: 'err-item',
                                content: error.description || error.text
                            };
                        }, this)
                    ]
                },

                !!(this.ctx.titleErrors.length) && {
                    block: 'b-edit-groups-error-header',
                    elem: 'sub-message',
                    content: [
                        iget2('b-edit-groups-error-header', 'ne-ukazano-nazvanie-gruppy', 'Не указано название группы') + ':',
                        this.ctx.titleErrors.map(function(group, i) {
                            return [
                                i == 0 ? ' ' : ', ',
                                {
                                    elem: 'group-link',
                                    elemMods: { type: 'title' },
                                    url: '#Group-' + group.modelId,
                                    group: group
                                }
                            ];
                        }, this)
                    ]
                },

                !!(this.ctx.bannersErrors.length) && {
                    block: 'b-edit-groups-error-header',
                    elem: 'sub-message',
                    content: [
                        iget2('b-edit-groups-error-header', 'oshibki-v-obyavleniyah', 'Ошибки в объявлениях') + ':',
                        this.ctx.bannersErrors.map(function(error, i) {

                            return [
                                i == 0 ? ' ' : ', ',
                                {
                                    elem: 'banner-link',
                                    banner: error.banner,
                                    group: error.group
                                }
                            ];
                        })
                    ]
                }
            ];
    }),

    elem('group-link').def()(function() {

        return applyCtx({
            block: 'link',
            mix: [{
                block: 'b-edit-groups-error-header',
                elem: 'group-link',
                elemMods: this.elemMods
            }],
            url: this.ctx.url,
            content: {
                block: 'b-edit-groups-error-header',
                elem: 'group-name',
                banner: this.ctx.banner,
                group: this.ctx.group
            }
        });
    }),

    elem('banner-link').def()(function() {

        return applyCtx({
            block: 'link',
            mix: [{
                block: 'b-edit-groups-error-header',
                elem: 'banner-link'
            }],
            url: '#Banner-' + this.ctx.group.modelId + '-' + this.ctx.banner.modelId,
            content: [
                {
                    block: 'b-edit-groups-error-header',
                    elem: 'banner-name',
                    banner: this.ctx.banner,
                    group: this.ctx.group
                },
                !this.ctx.group.isSingleGroup && [
                    ' (' + iget2('b-edit-groups-error-header', 'gruppa', 'группа'),
                    '&nbsp;',
                    {
                        block: 'b-edit-groups-error-header',
                        elem: 'group-name',
                        banner: this.ctx.banner,
                        group: this.ctx.group
                    },
                    ')'
                ]
            ]
        });
    }),

    elem('banner-name')(

        tag()('span'),

        content()(function() {
            return this.ctx.banner.isNewBanner ?
                iget2('b-edit-groups-error-header', 'novoe-obyavlenie', 'Новое объявление') + ' ' + this.ctx.banner.newBannerIndex :
                '№ M-' + this.ctx.banner.modelId;
        })
    ),

    elem('group-name')(

        tag()('span'),

        content()(function() {
            return (this.ctx.group.isNewGroup || this.ctx.group.isCopyGroup) ? iget2('b-edit-groups-error-header', 'novaya-gruppa-s', 'Новая группа {foo}', {
                foo: this.ctx.group.newGroupIndex
            }) : '№ ' + this.ctx.group.modelId;
        })
    )
);
