BEM.DOM.decl('b-edit-groups-error-header', {

    onSetMod: {
        js: function() {
            this.channel('multiedit-errors').on('invalid', this.onInvalidMultiedit, this);
        }
    },

    /**
     * Обработчик ошибок валидации модели
     * @param {Event} event событие
     * @param {Object} data информация об ошибке
     * @param {Array} data.invalidGroupsData список невалидных групп
     */
    onInvalidMultiedit: function(event, data) {
        var groups = BEM.MODEL.get(this.params.modelName || 'm-group'),
            bannersLength = 0,
            hasAllErrors;

        groups.forEach(function(group) {
            bannersLength = bannersLength + group.get('bannersIds').length;
        });

        hasAllErrors = data.groupsErrors.length == groups.length &&
            data.titleErrors.length == groups.length &&
            data.bannersErrors.length == bannersLength && !(data.genericErrors || []).length;

        BEM.DOM.update(this.elem('errors-list-wrapper'), BEMHTML.apply({
            block: 'b-edit-groups-error-header',
            elem: 'errors-list',
            titleErrors: data.titleErrors,
            groupsErrors: data.groupsErrors,
            bannersErrors: data.bannersErrors,
            genericErrors: data.genericErrors || [],
            hasAllErrors: hasAllErrors
        }));

        this.setMod('visible', 'yes');

        BEM.DOM.win.scrollTop(0);
    },

    destruct: function() {
        this.channel('multiedit-errors').un('invalid');

        this.__base.apply(this, arguments);
    }
}, {

    live: function() {
        this
            .liveBindTo('group-link banner-link', 'click', function(e) {
                // для DIRECT-40201 (жёлтая плашка наезжает на заголовок)
                // переопределяем поведение якорей, т. к. b-floater закрывает заголовок к которому был якорь
                // решил в итоге захардкодить отступ в 50px, чтобы не заниматься сложным поиском b-floater-а
                BEM.DOM.win.scrollTop($(e.data.domElem.attr('href')).offset().top - 50);

                e.preventDefault();
            });

        return false;
    }

});
