block('b-edit-groups-mass-actions-toggle').mod('type', 'cpm-banner')(

    def()(function() {
        var groups = this.data.campaign.groups,
            data = this.data.campaign.groups.reduce(function(res, group) {
                if (group.displayConditions === 'keywords') {
                    res.hasMinusWords = true;
                }
                // варианты: 'cpm_banner'|'cpm_video'|'cpm_outdoor'|'cpm_geoproduct'
                if (u.turbo.isGroupTypeSupported('cpm_banner', group.cpmGroupType)) {
                    res.isTurbolandingsEnabled = true;
                }
                return res;
            }, { isTurbolandingsEnabled: false, hasMinusWords: false }),
            groupsType = groups.map(function(group) {
                return group.cpmGroupType
            }),
            hasGeoproductGroupType = groupsType.some(function(groupType) {
                return groupType === 'cpm_geoproduct';
            }),
            haveDifferentGroupTypesWithGeoproduct = u._.uniq(groupsType).length > 1 && hasGeoproductGroupType;

        return applyNext({
            'ctx.massActionsData': {
                canEditDomain: false,
                hasNoClientRole: hasLoginRights(   // minus-words
                    'super_control',
                    'support_control',
                    'placer_control',
                    'manager_control',
                    'is_teamleader',
                    'media_control'
                ),
                isTurbolandingsEnabled: data.isTurbolandingsEnabled,
                hasMinusWords: data.hasMinusWords,
                groups: groups
            },
            'ctx.needBlockMassAction': haveDifferentGroupTypesWithGeoproduct
        });
    })
);
