block('b-edit-groups-mass-actions-toggle').mod('type', 'text')(

    def()(function() {
        var data = this.data,
            campaign = data.campaign,
            groups = campaign.groups,
            hasNoClientRole = hasLoginRights(
                'super_control',
                'support_control',
                'placer_control',
                'manager_control',
                'is_teamleader',
                'media_control'
            ),
            canEditDomain = hasLoginRights('super_control', 'support_control', 'placer_control', 'manager_control'),
            imageAdsGallery = (campaign.pictures || []).map(function(picture) {

                return u._.extend({
                    url: u.getImageUrl({
                        namespace: 'direct-picture',
                        mdsGroupId: picture.group_id,
                        hash: picture.hash
                    })
                }, picture);
            }),
            isTurbolandingsEnabled = Boolean(this.data.is_featureTurboLandingEnabled),
            massActionsData = this.ctx.massActionsData || {};

        return applyNext({
            'ctx.massActionsData': u._.extend(massActionsData, {
                canEditDomain: canEditDomain,
                imageAdsGallery: imageAdsGallery,
                images: campaign.images,
                isTurbolandingsEnabled: isTurbolandingsEnabled,
                clientId: campaign.ClientID,
                groups: groups,
                hasNoClientRole: hasNoClientRole,
                strategy: campaign.strategy
            })
        });
    })
);
