BEM.DOM.decl('b-edit-groups-mass-actions-toggle', {

    onSetMod: {
        js: function() {
            var needBlockMassAction = this.params.needBlockMassAction;

            u.graspSelf.call(this, {
                _toggle: 'button on popup-toggle-link',
                _tooltip: 'tooltip inside'
            });

            this._tooltip = this._tooltip.setOwner(this._toggle);

            this._subMan = BEM.create('i-subscription-manager');
            this._subMan.on(this._toggle, 'click', function() {
                this._getPopupDecorator().show();
            }, this);

            if (this.hasMod('type', 'text')) {
                BEM.blocks['b-metrika2'].params({
                    params: {
                        'text-multiedit-mass-actions': {
                            'toggle-shown': 1
                        }
                    }
                });
            }

            if (needBlockMassAction) {
                this._initTooltipEvents();
            }
        }
    },

    /**
     * Возвращает блок с декоратором
     * Если его нет - создает и заполняет блоком массового редактирования
     * @returns {BEM}
     * @private
     */
    _getPopupDecorator: function() {
        if (!this._popupDecorator) {
            this._popupDecorator = BEM.DOM.blocks['b-modal-popup-decorator'].create2(
                undefined,
                { bodyScroll: false, hasClose: true },
                $
            );
            this._massActions = this._popupDecorator.setPopupContent(u._.extend({
                block: 'b-edit-groups-mass-actions'
            }, this.params.massActionsData));

            this._initEvents();
        }

        return this._popupDecorator;
    },

    /**
     * Инициализация событий на попапе и внутреннем блоке
     * @private
     */
    _initEvents: function() {
        this._subMan.wrap(this._getPopupDecorator().getPopup())
            .on('hide', function() {
                this._massActions.trigger('popup-hidden');
            }, this)
            .on('show', function() {
                this._massActions.trigger('popup-shown');
            }, this);

        this._subMan.wrap(this._massActions)
            .on('hide-popup', function() {
                this._getPopupDecorator().hide();
            }, this);
    },

    _initTooltipEvents: function() {
        this.bindTo('wrap-popup-toggle-link', 'mouseover' , this._toggleTooltip);
        this.bindTo('wrap-popup-toggle-link', 'mouseleave' , this._toggleTooltip);
    },

    _toggleTooltip: function(event) {
        var isShow = event.type === 'mouseover';

        this._tooltip.toggleMod('shown', 'yes', '', isShow);
    }
});
