block('b-edit-groups-mass-actions').elem('buttons')(
    elem('buttons-group')(
        mode('new-href')(function() {
            return [
                {
                    action: 'new-href',
                    name: 'change-href',
                    title: iget2('b-edit-groups-mass-actions', 'izmenit-ssylku', 'Изменить ссылку'),
                    primary: true,
                    disabled: true
                },
                'cancel'
            ]
        }),

        mode('href-part')(function() {
            return [
                {
                    action: 'update-href',
                    name: 'update-href',
                    title: iget2('b-edit-groups-mass-actions', 'izmenit-chast-ssylki', 'Изменить часть ссылки'),
                    primary: true,
                    disabled: true
                },
                'cancel'
            ]
        }),

        mode('new-domain')(function() {
            return [
                {
                    action: 'replace-domain',
                    name: 'replace-domain',
                    title: iget2('b-edit-groups-mass-actions', 'izmenit-domen', 'Изменить домен'),
                    primary: true,
                    disabled: true
                },
                'cancel'
            ]
        }),

        mode('text-part')(function() {
            return [
                {
                    action: 'update-text',
                    name: 'update-text',
                    title: iget2('b-edit-groups-mass-actions', 'izmenit-chast-teksta', 'Изменить часть текста'),
                    primary: true,
                    disabled: true
                },
                'cancel'
            ]
        }),

        mode('minus-words')(function() {
            return [
                {
                    action: 'update-minus-words',
                    name: 'update-minus-words',
                    title: iget2('b-edit-groups-mass-actions', 'izmenit-minus-slova', 'Изменить минус слова'),
                    primary: true,
                    disabled: true
                },
                'cancel'
            ]
        }),

        mode('add-sitelinks')(function() {
            return [
                {
                    action: 'add-sitelinks',
                    name: 'add-sitelinks-btn',
                    title: iget2('b-edit-groups-mass-actions', 'izmenit-bystrye-ssylki', 'Изменить быстрые ссылки'),
                    primary: true,
                    disabled: true
                },
                'cancel'
            ]
        }),

        mode('add-turbolandings')(function() {
            return [
                {
                    action: 'add-turbolandings',
                    name: 'add-turbolandings-btn',
                    title: iget2('b-edit-groups-mass-actions', 'change-turbo', 'Изменить турбо-страницы'),
                    primary: true,
                    disabled: true
                },
                'cancel'
            ]
        }),

        mode('callouts')(function() {
            return [
                {
                    action: 'change-callouts',
                    name: 'change-callouts-btn',
                    title: iget2('b-edit-groups-mass-actions', 'izmenit-utochneniya', 'Изменить уточнения'),
                    primary: true,
                    disabled: true
                },
                'cancel'
            ]
        }),

        mode('replace-display-href')(function() {
            return [
                {
                    action: 'replace-display-href',
                    name: 'replace-display-href-btn',
                    title: iget2(
                        'b-edit-groups-mass-actions',
                        'izmenit-otobrazhaemuyu-ssylku',
                        'Изменить отображаемую ссылку'
                    ),
                    primary: true,
                    disabled: true
                },
                'cancel'
            ]
        }),

        mode('mobile-content-additions')(function() {
            return [
                {
                    action: 'mobile-content-additions',
                    name: 'set-mobile-content-additions',
                    title: iget2(
                        'b-edit-groups-mass-actions',
                        'primenit',
                        'Применить'
                    ),
                    primary: true,
                    disabled: true
                },
                'cancel'
            ]
        }),

        mode('new-tracking-href')(function() {
            return [
                {
                    action: 'new-tracking-href',
                    name: 'new-tracking-href',
                    title: iget2('b-edit-groups-mass-actions', 'izmenit-ssylku', 'Изменить ссылку'),
                    primary: true,
                    disabled: true
                },
                'cancel'
            ]
        }),

        mode('tracking-href-part')(function() {
            return [
                {
                    action: 'replace-tracking-href-part',
                    name: 'replace-tracking-href-part',
                    title: iget2('b-edit-groups-mass-actions', 'izmenit-chast-ssylki', 'Изменить часть ссылки'),
                    primary: true,
                    disabled: true
                },
                'cancel'
            ]
        }),

        mode('change-condition-tree-available')(function() {
            return [
                {
                    action: 'change-condition-tree-available',
                    name: 'change-condition-tree-available',
                    title: iget2('b-edit-groups-mass-actions', 'izmenit-usloviya-dereva-kategoriy', 'Изменить условия дерева категорий'),
                    primary: true,
                    disabled: false

                },
                'cancel',
                'spin'
            ]
        }),

        mode('change-target-funnel')(function() {
            return [
                {
                    action: 'change-target-funnel',
                    name: 'change-target-funnel',
                    title: iget2('b-edit-groups-mass-actions', 'izmenit-celevuyu-auditoriyu', 'Изменить целевую аудиторию'),
                    primary: true,
                    disabled: false

                },
                'cancel',
                'spin'
            ]
        }),

        mode('change-condition-tree-all')(function() {
            return [
                {
                    action: 'change-condition-tree-all',
                    name: 'change-condition-tree-all',
                    title: iget2('b-edit-groups-mass-actions', 'izmenit-usloviya-dereva-kategoriy', 'Изменить условия дерева категорий'),
                    primary: true,
                    disabled: true

                },
                'cancel',
                'spin'
            ]
        }),

        mode('change-condition-tree-price')(function() {
            return [
                {
                    action: 'change-condition-tree-price',
                    name: 'change-condition-tree-price',
                    title: iget2('b-edit-groups-mass-actions', 'izmenit-usloviya-dereva-kategoriy', 'Изменить условия дерева категорий'),
                    primary: true,
                    disabled: false

                },
                'cancel',
                'spin'
            ]
        }),

        mode('video')(function() {
            return [
                {
                    action: 'save-video',
                    name: 'save-video-btn',
                    title: iget2('b-edit-groups-mass-actions', 'save-video', 'Сохранить'),
                    primary: true,
                    disabled: true
                },
                {
                    action: 'remove-all-video',
                    name: 'remove-all-video-btn',
                    title: iget2('b-edit-groups-mass-actions', 'remove-all-video', 'Отвязать у всех объявлений'),
                    primary: false,
                    disabled: false
                },
                'cancel'
            ]
        }),

        mode('pixel-audience')(function() {
            return [
                {
                    action: 'update-pixel-audience',
                    name: 'update-pixel-audience',
                    title: iget2('b-edit-groups-mass-actions', 'izmenit-piksel-ja-auditorij', 'Изменить пиксель Я.Аудиторий'),
                    disabled: true,
                    primary: true

                },
                'cancel'
            ]
        }),

        mode('pixel-audit')(function() {
            return [
                {
                    action: 'update-pixel-audits',
                    name: 'update-pixel-audits',
                    title: iget2('b-edit-groups-mass-actions', 'izmenit-piksel-audit', 'Изменить счетчик показов'),
                    disabled: true,
                    primary: true
                },
                'cancel'
            ]
        }),

        mode('creative')(function() {
            return [
                {
                    action: 'creative',
                    name: 'creative',
                    title: iget2('b-edit-groups-mass-actions', 'save-image-button-cpm', 'Сохранить креатив'),
                    primary: true,
                    disabled: true
                },
                'cancel'
            ]
        }),

        mode('pic-selector')(function() {
            return [
                {
                    action: 'banner-pic-back',
                    name: 'banner-pic-back',
                    title: iget2('b-edit-groups-mass-actions', 'nazad', '← Назад'),
                    primary: false,
                    disabled: true
                },
                {
                    action: 'banner-pic-save',
                    name: 'banner-pic-save',
                    title: iget2('b-edit-groups-mass-actions', 'sohranit', 'Сохранить'),
                    primary: true,
                    disabled: true
                },
                'cancel'
            ]
        }),

        content()(function() {
            var buttons = apply(this.ctx.action);

            return buttons.map(function(button) {
                if (button === 'cancel') {
                    return {
                        block: 'button',
                        mix: [{
                            block: 'b-edit-groups-mass-actions',
                            elem: 'popup-button',
                            elemMods: {
                                action: 'cancel'
                            }
                        }],
                        type: 'button',
                        name: 'cancel',
                        content: iget2('b-edit-groups-mass-actions', 'otmena', 'Отмена')
                    };
                }

                if (button === 'spin') {
                    return {
                        block: 'spin',
                        mix: {
                            block: 'b-edit-groups-mass-actions',
                            elem: 'action-spin'
                        },
                        mods: {
                            theme: 'gray-16'
                        }
                    }
                }

                return {
                    block: 'button',
                    mods: {
                        theme: button.primary ? 'action' : '',
                        disabled: button.disabled ? 'yes' : ''
                    },
                    mix: [{
                        block: 'b-edit-groups-mass-actions',
                        elem: 'popup-button',
                        elemMods: {
                            action: button.action
                        }
                    }],
                    type: 'button',
                    name: button.name,
                    content: button.title
                }
            });
        })
    ),

    content()(function() {
        var action = this.ctx.action;

        return {
            elem: 'buttons-group',
            elemMods: { type: action },
            action: action
        }
    })
);
