block('b-edit-groups-mass-actions').elem('chooser').content()(function() {
    var ctx = this.ctx,
        actionsTitles = ctx.actionsTitles;

    return {
        block: 'b-chooser',
        mods: { style: 'stretched-items', theme: 'strategies-list' },
        content: ctx.actions.map(function(actionName) {
            if (ctx.disabledActions.indexOf(actionName) !== -1) {
                return {
                    block: 'b-edit-groups-mass-actions',
                    elem: 'actions-header',
                    mix: { block: 'b-chooser', elem: 'item', elemMods: { disabled: 'yes' } },
                    content: actionsTitles[actionName]
                }
            } else {
                return {
                    elem: 'item',
                    elemMods: {
                        selected: actionName === ctx.selectedAction ? 'yes' : '',
                        hidden: (ctx.hiddenActions || []).indexOf(actionName) !== -1 ? 'yes' : ''
                    },
                    mix: { block: this.block, elem: 'tab-' + actionName },
                    content: actionsTitles[actionName],
                    name: actionName,
                    js: { extraParams: { name: actionName } }
                };
            }
        })
    }
});
