block('b-edit-groups-mass-actions').mod('type', 'cpm-banner')(

    def()(function() {
        var ctx = this.ctx,
            canEditMinusWords = !ctx.isSingleGroup && ctx.hasMinusWords,
            canModifyHref = apply('has-banner-with-own-site'),
            visible = ctx.groups.reduce(function(res, group) {
                if (!res.audit) {
                    res.audit = group.cpmGroupType === 'cpm_banner' || group.cpmGroupType === 'cpm_video' ||
                        group.cpmGroupType === 'cpm_audio';
                }

                if (!res.audience) {
                    res.audience = group.cpmGroupType === 'cpm_banner';
                }

                return res;
            }, { audit: false, audience: false });

        return applyNext({
            'ctx.actions': [
                canModifyHref && 'new-href',
                canModifyHref && 'href-part',
                ctx.hasNoClientRole && canEditMinusWords && 'minus-words',
                'creative',
                ctx.isTurbolandingsEnabled && 'add-turbolandings',
                visible.audience && 'pixel-audience',
                visible.audit && 'pixel-audit'
            ].filter(function(val) {
                return val;
            })
        });
    })
);
