BEM.DOM.decl({ name: 'b-edit-groups-mass-actions', modName: 'type', modVal: 'cpm-deals' }, {

    /**
     * Возвращает adType для действий с креативами и изображениями
     * @returns {String}
     * @private
     */
    _getImageBannerAdType: function() {
        return 'cpm_deals';
    },

    /**
     * Добавляет минус слова ко фразам баннера
     * @private
     */
    _addMinusWords: function() {
        var noMinusWords = false;

        this._eachGroupModel(function(model) {
            model.get('displayConditions') === 'crypta' && (noMinusWords = true);
        });

        if (noMinusWords) {
            this._showMessage(iget2('b-edit-groups-mass-actions', 'no-words-groups-alert',
                'Минус слова будут добавлены только для групп объявлений с условиями показа по ключевым фразам.'
            ))
        }

        return this.__base.apply(this, arguments);
    },

    /**
     * Обновляет минус слова м модели фразы
     * @param {BEM.MODEL} phraseModel
     * @param {Array} minusWords
     * @private
     */
    _updatePhraseMinusWords: function(phraseModel, minusWords) {
        phraseModel.set(
            'minus_words',
            u._.unique(phraseModel.get('minus_words').concat(minusWords)),
            { source: 'multiedit' }
        );
    },

    _isImageAd: function() {
        return true;
    }

});
