BEM.DOM.decl({ name: 'b-edit-groups-mass-actions', modName: 'type', modVal: 'mobile-content' }, {

    onSetMod: {

        js: function() {
            this._actions = u._.extend(this._actions, {
                'mobile-content-additions': this._setMobileContentAdditions,
                'new-tracking-href': this._setNewTrackingHref,
                'replace-tracking-href-part': this._replaceTrackingHrefPart
            });

            this.__base.apply(this, arguments);
        }

    },

    /**
     * Подписывает на события и инициализирует необходимые элементы
     */
    _initialize: function() {
        this._chooser = this.findBlockInside('b-chooser');

        this._actionsParams = this.params; // параметры блока
        this._currentActionName = this._actionsParams.defaultAction; // Идентификатор первой вкладки
        this._actionTitles = u['b-edit-groups-mass-actions'].getActionsTitles(); // заголовки блоков
        this._subMan = BEM.create('i-subscription-manager');

        this._subMan.on(this._chooser, 'change', function(e, data) {
            this._currentActionName = data.extraParams.name;
            this._onChooserChanged(this._currentActionName);
        }, this);

        this._onChooserChanged(this._currentActionName);
    },

    /**
     * Устанавливает дополнительные параметры для групп объявлений рекламы мобильного контента
     * @private
     */
    _setMobileContentAdditions: function() {
        var values = this._additionsItems.reduce(function(res, item) {
            var val = item.val();

            val !== 'no-change' && (res[item.name()] = val === 'turn-on');

            return res;
        }, {});

        if (!this._getEditableBanners('additions').length) {
            return false;
        }

        this._eachGroupModel(function(model) {
            var contentModel = model.get('mobile_content'),
                availableAttrs;

            if (!contentModel) return;

            availableAttrs = u['dm-mobile-content'].getAvailableAttrs(contentModel.toJSON());
            model.getBanners().forEach(function(banner) {
                var current = banner.get('reflected_attrs') || [],
                    isImageAd = this._isImageAd(banner);

                !isImageAd && banner.set(
                    'reflected_attrs',
                    availableAttrs.reduce(function(res, item) {
                        if ((values[item] !== false && current.indexOf(item) !== -1) || values[item]) {
                            res.push(item);
                        }

                        return res;
                    }, []));
            }, this);
        }, this);

        return true;
    },

    /**
     * Устанавливает новую треккинговую ссылку
     * @private
     */
    _setNewTrackingHref: function() {
        var newValue = {
            href: u._.uniq(this._getInput('new-tracking-href-input').val().split('&')).join('&')
        };

        if (!this._getEditableBanners('tracking-href').length) {
            return false;
        }

        this._eachBannerModel(function(model) {
            model.update(newValue, {
                action: 'mass'
            });
        });

        this._getInput('new-tracking-href-input').val('');

        return true;
    },

    /**
     * Заменяет часть треккинговой ссылки
     * @private
     */
    _replaceTrackingHrefPart: function() {
        var textFrom = this._getInput('tracking-href-from').val(),
            textTo = this._getInput('tracking-href-to').val(),
            regexp = new RegExp(this._regexpEscape(textFrom).replace(/\s/gi, '\\s'), 'gi'),
            isTextChanged = false;

        if (!this._getEditableBanners('tracking-href').length) {
            return false;
        }

        if (!textFrom) {
            this._showErrorMessage(iget2('b-edit-groups-mass-actions', 'vvedite-stroku-dlya-poiska', 'Введите строку для поиска'));

            return false;
        }

        this._eachBannerModel(function(model) {
            var href = model.get('href') || '';

            if (regexp.test(href)) {
                isTextChanged = true;
                model.set('href', href.replace(regexp, textTo), {
                    action: 'mass'
                });
            }
        });

        if (!isTextChanged) {
            this._showErrorMessage(iget2('b-edit-groups-mass-actions', 'ne-nayden-fragment-dlya', 'Не найден фрагмент для замены.'));

            return false;
        }

        this._getInput('tracking-href-from').val('');
        this._getInput('tracking-href-to').val('');

        return true;
    },

    /**
     * Событие изменения треккинговой ссылки
     * @param {BEM} block
     * @private
     */
    _onNewTrackingHrefChange: function(block) {
        var value = block.val();

        value && block.val(value);

        this._checkPopupButton(value, 'new-tracking-href');
    },

    /**
     * Открывает новый таб
     * @private
     * @overrdie
     */
    _openAction: function() {
        this.__base.apply(this, arguments);

        this._initAdditionals();
    },

    /**
    * Привязка событий при изменении текстовых полей
    * @private
    * @override
    */
    _bindTextInputs: function() {
        ['tracking-href-from', 'text-from'].forEach(function(item) {
            this._getInput(item) && this._getInput(item).on('change', function(e) {
                var input = e.block;

                this._checkPopupButton(!!input.val().length, input.params.forAction);
            }, this);
        }, this);

        return this;
    },

    /**
     * Инициализация блока "дополнительные параметры" для РМП
     * @returns {_initAdditionals}
     * @private
     */
    _initAdditionals: function() {
        this._getInput('new-tracking-href-input') && this._getInput('new-tracking-href-input')
            .on('change', function(e, data) {
                if (data && data.striped) return;

                this._onNewTrackingHrefChange(e.block);
            }, this);

        this._additionsItems = this.findBlocksOn('mobile-content-additions-item', 'radio-button');
        this._setAdditionsButton = this.findBlockOn(
            this.findElem('popup-button', 'action', 'mobile-content-additions'),
            'button'
        );

        this._subMan.on(this, 'popup-shown', function() {
            this._additionsItems.forEach(function(item) {
                item.val('no-change');
            });
        }, this);

        BEM.blocks['radio-button'].on(
            this.elem('mobile-content-additions-item'),
            'change',
            function() {
                var isChange = this._additionsItems.some(function(item) { return item.val() !== 'no-change' });

                this._setAdditionsButton.setMod('disabled', isChange ? '' : 'yes');
            }, this);

        return this;
    }

});
