block('b-edit-groups-mass-actions').mod('type', 'performance')(

    def()(function() {
        return applyNext({
            'ctx.actions': [
                'change-target-funnel',
                'change-condition-tree-available',
                'change-condition-tree-price',
                'change-condition-tree-all'
            ]
        });
    }),

    elem('action-tooltip').content()(function() {
        return iget2(
            'b-edit-groups-mass-actions',
            'izmeneniya-budut-primeneny-dlya',
            'Изменения будут применены для условий, которые указаны на вкладке {tabName} в фильтрах.',
            {
                tabName: {
                    elem: 'action-tooltip-bold',
                    content: iget2('b-edit-groups-mass-actions', 'derevo-kategoriy', 'Дерево категорий')
                }
            }
        );
    }),

    elem('change-condition-tree-available-content').content()(function() {
        return {
            block: 'radio-button',
            mix: { block: 'b-edit-groups-mass-actions', elem: 'change-condition-tree-available-control' },
            value: 'turn-on',
            content: [
                {
                    elem: 'radio',
                    controlAttrs: { value: 'turn-on' },
                    content: iget2('b-edit-groups-mass-actions', 'vklyuchit-vsem', 'Включить всем')
                },
                {
                    elem: 'radio',
                    controlAttrs: { value: 'turn-off' },
                    content: iget2('b-edit-groups-mass-actions', 'vyklyuchit-vsem', 'Выключить всем')
                }
            ]
        };
    }),

    elem('change-condition-tree-all-content').content()(function() {
        return {
            block: 'checkbox',
            mix: { block: 'b-edit-groups-mass-actions', elem: 'change-condition-tree-all-control' }
        }
    }),

    elem('change-condition-tree-price-content').content()(function() {
        var defaultPriceRelation = { field: 'price', relation: '<->', id: 'price-mass-action' },
            price = u._.extend({}, defaultPriceRelation, {
                value: u['i-filter-edit'].getDefaultValue(defaultPriceRelation)
            });

        return {
            block: 'b-error-presenter',
            content: [
                {
                    block: 'filter-condition-edit-control',
                    mix: { block: 'b-edit-groups-mass-actions', elem: 'change-condition-tree-price-control' },
                    mods: { type: 'composite' },
                    hideCompositeControls: true,
                    itemId: price.id,
                    condition: price
                },
                {
                    block: 'b-error-message',
                    js: { path: 'feed-filter-edit.filter.all-prices.total' }
                }
            ]
        }
    })
);
