BEM.DOM.decl({ name: 'b-edit-groups-mass-actions', modName: 'type', modVal: 'performance' }, {
    onSetMod: {

        js: function() {
            this._actions = u._.extend(this._actions, {
                'change-target-funnel': this._setTargetFunnel,
                'change-condition-tree-all': this._setConditionTreeAll,
                'change-condition-tree-price': this._setConditionTreePrice,
                'change-condition-tree-available': this._setConditionTreeAvailable
            });

            this._initActions = u._.extend(this._initActions, {
                'change-target-funnel': function() {
                    this._initChangeTargetFunnel();
                },

                'change-condition-tree-available': function() {
                    this._initConditionTreeAction('change-condition-tree-available');
                },

                'change-condition-tree-all': function() {
                    this._initConditionTreeAction('change-condition-tree-all');
                },
                'change-condition-tree-price': function() {
                    this._initConditionTreeAction('change-condition-tree-price');
                }
            });

            this.__base.apply(this, arguments);
        },

        'is-saving': function(modName, modVal) {
            if (!this._actionSpin) {
                this._actionSpin = this.findBlockOn('action-spin', 'spin');
            }

            this._actionSpin.setMod('progress', modVal);
            //дизейблим кнопки действий пока идет сохранение
            ['change-condition-tree-all', 'change-condition-tree-price', 'change-condition-tree-available', 'cancel']
                .forEach(function(name) {
                    this._checkPopupButton(modVal !== 'yes', name);
                }, this);
        }

    },

    /**
     * Подписывает на события и инициализирует необходимые элементы
     */
    _initialize: function() {
        this._chooser = this.findBlockInside('b-chooser');

        this._actionsParams = this.params;
        this._actionTitles = u['b-edit-groups-mass-actions'].getActionsTitles();
        this._currentActionName = this._actionsParams.defaultAction; // Идентификатор первой вкладки
        this._subMan = BEM.create('i-subscription-manager');

        this._subMan.wrap(this._chooser).on('change', function(e, data) {
            this._currentActionName = data.extraParams.name;
            this._onChooserChanged(this._currentActionName);
        }, this);

        this.hasMod('single') && this._subMan.wrap(BEM.MODEL)
            .on(this._actionsParams.modelName, 'bannersIds', 'change', function(e, data) {
                this.setMod('visible', data.value.length > 1 ? 'yes' : '');
            }, this);

        this._subMan.on(this, 'popup-shown', function() {
            this._onChooserChanged(this._currentActionName);
        }, this);

        this
            ._bindOnPopupHide(this._onPopupHide, this);
    },

    /**
     * Инициализирует вкладку таба "Целевая аудитория"
     * @private
     */
    _initChangeTargetFunnel: function() {
        var actionsParams = this._actionsParams;

        this._initActionPane('change-target-funnel');

        if (!this._targetFunnelBlock) {
            this._showSpin('change-target-funnel');

            BEM.DOM.update(
                this._actionsPanes['change-target-funnel'],
                BEMHTML.apply({
                    block: 'b-feed-filter-target-funnel',
                    mods: { multi: 'yes' },
                    filter: { target_funnel: 'new_auditory' },
                    adgroupType: actionsParams.mediaType,
                    cid: actionsParams.cid
                })
            );

            this._targetFunnelBlock = this.findBlockInside('b-feed-filter-target-funnel');
            this._targetFunnelBlock.initBlock();

            var cid = this.params.cid,
                model = BEM.MODEL.getOne({ name: 'b-feed-filter-target-funnel_multi_yes', cid: cid }),
                isSearchSelected = model.getParentCampaignDM().get('strategy').is_net_stop === 1;

            model.on('target_funnel', 'change', function(e, data) {
                // Обрабатываем только те случаи, когда стратегия настроена на "поиск"
                if (!isSearchSelected) {
                    return;
                }

                var targetFunnel = data.value,
                    isSelectedProductPageVisit = targetFunnel === 'product_page_visit';

                // блокируем кнопку, только когда выбрана целевая аудитория "Смотрели товары на моем сайте"
                this._checkPopupButton(!isSelectedProductPageVisit, 'change-target-funnel');
            }, this);
        }
    },

     /**
     * Инициализирует вкладку для таба Дерево категорий: *
     * @param {'change-condition-tree-all'|'change-condition-tree-available'|'change-condition-tree-price'} actionName
     * @returns {BEM}
     * @private
     */
    _initConditionTreeAction: function(actionName) {
        this._initActionPane(actionName);

        if (!this._conditionTreeBlocks) this._conditionTreeBlocks = {};

        if (!this._conditionTreeBlocks[actionName]) {
            this._showSpin(actionName);

            BEM.blocks['i-filter-edit'].loadConfig().then(function() {
                BEM.DOM.update(this._actionsPanes[actionName],
                    BEMHTML.apply({
                        block: 'b-edit-groups-mass-actions',
                        mods: { type: 'performance' },
                        //actionName например change-condition-tree-all, получаем change-condition-tree-all-content
                        elem: actionName + '-content'
                    }));

                var actionControls = this._getControlForTreeAction(actionName);

                this._conditionTreeBlocks[actionName] = actionControls;

                if (actionName === 'change-condition-tree-all') {
                    this._checkPopupButton(false, 'change-condition-tree-all');

                    actionControls.on('change', function() {
                        this._checkPopupButton(actionControls.isChecked(), 'change-condition-tree-all');
                    }, this);
                }

            }.bind(this));
        }

        return this;
    },

    /**
     * Инициализирует контролл для таба Дерево категорий: *
     * @param {'change-condition-tree-all'|'change-condition-tree-available'|'change-condition-tree-price'} actionName
     * @returns {BEM}
     * @private
     */
    _getControlForTreeAction: function(actionName) {
        switch (actionName) {
            case 'change-condition-tree-all':
                return this.findBlockOn('change-condition-tree-all-control', 'checkbox');
            case 'change-condition-tree-available':
                return this.findBlockOn('change-condition-tree-available-control', 'radio-button');
            case 'change-condition-tree-price':
                return this.findBlockOn('change-condition-tree-price-control', 'filter-condition-edit-control')
        }
    },

    /**
     * Инициализируем обертку, в которую будем вставлять содержимое таба
     * @param {'change-condition-tree-all'|'change-condition-tree-price'|'change-condition-tree-available'|'change-target-funnel'} actionPaneName
     * @returns {BEM}
     * @private
     */
    _initActionPane: function(actionPaneName) {
        if (!this._actionsPanes) { this._actionsPanes = {}; }
        if (!this._actionsPanes[actionPaneName]) {
            this._actionsPanes[actionPaneName] = this.findElem('action-content', 'action', actionPaneName);
        }

        return this;
    },

    /**
     * Показываем крутилку
     * @param {'change-condition-tree-all'|'change-condition-tree-price'|'change-condition-tree-available'|'change-target-funnel'} actionPaneName
     * @returns {BEM}
     * @private
     */
    _showSpin: function(actionPaneName) {
        BEM.DOM.update(this._actionsPanes[actionPaneName], BEMHTML.apply({
            block: 'spin',
            mix: { block: 'b-edit-groups-mass-actions', elem: 'set-content-spin' },
            mods: { theme: 'gray-16', progress: 'yes' }
        }));

        return this;
    },

    /**
     * При закрытии попапа откатываем введенные значения
     * @private
     */
    _onPopupHide: function() {
        this._targetFunnelBlock && this._targetFunnelBlock.destruct();
        this._conditionTreeBlocks && u._.forEach(this._conditionTreeBlocks, function(block) {
            block && block.destruct();
        });

        this._targetFunnelBlock = undefined;
        this._conditionTreeBlocks = undefined;
    },

    /**
     * Устанавливает целевую аудиторию во всех фильтрах
     * @private
     */
    _setTargetFunnel: function() {
        var targetFunnel = this._targetFunnelBlock.getTargetFunnel();

        this._eachGroupModel(function(model) {
            model.get('feed_filters').forEach(function(feedFilterModel) {
                feedFilterModel.set('target_funnel', targetFunnel);
                //если Целевая аудитория не "Обе группы", то нужно сбросить данные про Условия подбора
                if (targetFunnel !== 'same_products') {
                    feedFilterModel.set('retargetings', []);
                }
            });
        });

        BEM.blocks['b-edit-groups-mass-actions'].trigger('filters-mass-actions:completed');

        return true;
    },

    /**
     * Устанавливаем/снимает флаг "В наличии" для всех условий фильтров
     * @returns {boolean}
     * @private
     */
    _setConditionTreeAvailable: function() {
        var val = this._conditionTreeBlocks['change-condition-tree-available'].val(),
            isAvailable = val === 'turn-on';

        this._eachGroupModel(function(model) {
            model.setFeedsAvailable(isAvailable);
        });

        BEM.blocks['b-edit-groups-mass-actions'].trigger('filters-mass-actions:completed');

        return true;
    },

    /**
     * Устанавливаем/снимаем флаг "Выбраны все категории" для фильтров
     * @returns {boolean}
     * @private
     */
    _setConditionTreeAll: function() {
        var isSelectAll = true,
            setCategoryIdPromisesList = [],
            setCategoryIdPromise;

        this.setMod('is-saving', 'yes');

        this._eachGroupModel(function(model) {
            setCategoryIdPromise = model.setFeedsAllCategoriesIds(isSelectAll);

            setCategoryIdPromisesList.push(setCategoryIdPromise);
        });

        $.when(setCategoryIdPromisesList).done(function() {
            this.delMod('is-saving');
            this.trigger('hide-popup');
        }.bind(this));

        BEM.blocks['b-edit-groups-mass-actions'].trigger('filters-mass-actions:completed');

        return false;

    },

    /**
     * Устанавливаем цены для всех фильтров
     * @returns {Boolean}
     * @private
     */
    _setConditionTreePrice: function() {
        var data,
            validateResult,
            price = this._conditionTreeBlocks['change-condition-tree-price'].getData();

        price = price[0] && (price[0].min || price[0].max) ? price : [];
        data = { value: price, field: 'price', relation: '<->', id: 'price-mass-action' };

        validateResult = u['i-filter-edit'].validateCondition(data);

        if (!validateResult.isValid && validateResult.errors && validateResult.errors.total &&
            (validateResult.errors.total.length == 1) && validateResult.errors.total[0].rule === 'itemsCountMin') {

            this._showConfirm(
                iget2('b-edit-groups-mass-actions', 'vnimanie-diapazon-cen-budet', 'Внимание! Диапазон цен будет удален из всех фильтров.'),
                function() {
                    this._eachGroupModel(function(model) {
                        model.clearFeedsPrice();
                    });
                    this.trigger('hide-popup');
                });
        }

        if (!validateResult.isValid) {
            this._showPriceErrors(validateResult.errors);

            return false;
        }

        data.value = u['i-filter-edit__preprocess'].preprocessValueToServer(data.field, data.relation, data.value);

        this._eachGroupModel(function(model) {
            model.setFeedsPrice(data);
        });

        BEM.blocks['b-edit-groups-mass-actions'].trigger('filters-mass-actions:completed');

        return true;
    },

    /**
     * Удаляет сообщения об ошибках
     * @private
     */
    _clearErrors: function() {
        this._getErrorPresenter().clearErrors();

        return this;
    },

    _showPriceErrors: function(errors) {
        this._clearErrors();

        this._getErrorPresenter().showErrors(
            u['error'].flattenClient(errors, 'feed-filter-edit.filter.price-mass-action')
        );
    },

    /**
     * Возвращает блок распределения ошибок
     * @returns {BEM.DOM}
     * @protected
     */
    _getErrorPresenter: function() {
        return this._errorPresenter ||
            (this._errorPresenter = this.findBlockInside('change-condition-tree-price-content', 'b-error-presenter'));
    }
});
