block('b-edit-groups-mass-actions')(

    mode('has-banner-with-own-site')(function() {
        var groupsCount = this.ctx.groups.length,
            hasBannerWithOwnSite = false;
        // Поиск во всех открытых на редактирование группах кампании первого объявления, у которого есть свой сайт,
        // чтобы выставить флаг, который будет влиять на отображение опций редактирования ссылок на сайты у баннеров
        // через попап массовых действий
        for (var i = 0; i < groupsCount; i++) {
            var banners = this.ctx.groups[i].banners,
                bannersCount = banners.length;

            for (var j = 0; j < bannersCount; j++) {
                if (banners[j].has_site_enum === 'yes') {
                    hasBannerWithOwnSite = true;
                    break;
                }
            }

            if (hasBannerWithOwnSite) break;
        }
        return hasBannerWithOwnSite;
    }),

    js()(function() {
        var ctx = this.ctx;

        return {
            clientId: ctx.clientId,
            mediaType: ctx.mediaType,
            cid: ctx.cid,
            strategy: ctx.strategy,
            modelName: ctx.modelName,
            adgroupIds: ctx.adgroupIds,
            canEditDomain: ctx.canEditDomain,
            imageAdsGallery: ctx.imageAdsGallery,
            images: ctx.images,
            minusWords: !ctx.isSingleGroup,
            isSingle: ctx.isSingleGroup,
            isTurbolandingsEnabled: ctx.isTurbolandingsEnabled,
            groups: ctx.groups,
            actions: ctx.actions,
            defaultAction: ctx.actions[0],
            hiddenActions: ctx.hiddenActions || [],
            hasMinusWords: ctx.hasMinusWords
        }
    }),

    content()(function() {
        var ctx = this.ctx;

        return {
            block: 'b-edit-groups-mass-actions',
            elem: 'popup-content',
            mods: ctx.mods,
            canEditDomain: ctx.canEditDomain,
            isTurbolandingsEnabled: ctx.isTurbolandingsEnabled,
            isSingleGroup: ctx.isSingleGroup,
            hasNoClientRole: ctx.hasNoClientRole,
            actions: ctx.actions,
            defaultAction: ctx.actions[0],
            //cpm_banner
            hasMinusWords: ctx.hasMinusWords
        }
    }),

    elem('popup-content')(
        content()(function() {
            var ctx = this.ctx,
                actions = ctx.actions,
                defaultAction = ctx.defaultAction;

            return [
                {
                    elem: 'title'
                },
                {
                    elem: 'body',
                    actions: actions,
                    defaultAction: defaultAction
                },
                {
                    elem: 'footer',
                    defaultAction: defaultAction
                }
            ];
        })
    ),

    elem('title')(

        mix()({ block: 'b-modal-popup-decorator', elem: 'header' }),

        tag()('h3'),

        content()(function() {
            return iget2('b-edit-groups-mass-actions', 'massovye-izmeneniya', 'Массовые изменения')
        })
    ),

    elem('body').content()(function() {
        var actionTitles = this.ctx.actionTitles || u['b-edit-groups-mass-actions'].getActionsTitles(),
            defaultAction = this.ctx.defaultAction;

        return [
            {
                elem: 'chooser',
                actions: this.ctx.actions,
                actionsTitles: actionTitles,
                selectedAction: defaultAction,
                disabledActions: ['additional'],
                hiddenActions: this.ctx.hiddenActions
            },
            {
                elem: 'action-panel',
                mix: [
                    {
                        block: 'i-glue',
                        js: {
                            modelParams: {
                                name: 'b-edit-groups-mass-actions',
                                id: 'campaign'
                            }
                        }
                    },
                    { block: 'b-modal-popup-decorator', elem: 'body' }
                ],
                id: 'mass-actions',
                content: [
                    {
                        block: 'b-edit-groups-mass-actions',
                        elem: 'action-title',
                        content: actionTitles[defaultAction]
                    },
                    {
                        block: 'b-edit-groups-mass-actions',
                        elem: 'action',
                        // по дефолту ничего не рисуем, так как надо передать еще и правильные параметры
                        elemMods: { type: '' }
                    }
                ]
            }
        ]
    }),

    elem('footer')(
        mix()({ block: 'b-modal-popup-decorator', elem: 'footer' }),
        content()(function() {
            return {
                block: 'b-edit-groups-mass-actions',
                elem: 'buttons',
                action: this.ctx.defaultAction
            };
        })
    )

);
