BEM.DOM.decl({ block: 'b-edit-groups-mass-actions', implements: 'i-modal-popup-inner-block-interface' }, {

    onSetMod: {
        js: function() {
            this.__base.apply(this, arguments);

            this._initialize();
        }
    },

    /**
     * Были ли изменения
     * Для интерфейса i-modal-popup-inner-block-interface
     * @returns {$.Deferred<Boolean>}
     */
    isChanged: function() {
        var deferred = $.Deferred();

        deferred.resolve(false);

        return deferred;
    },

    /**
     * Удаляет блок и модель
     */
    destruct: function() {
        this._subMan.dispose();

        return this.__base.apply(this, arguments);
    },

    /**
     * Подписывает на события и инициализирует необходимые элементы
     * @private
     */
    _initialize: function() {
        this._chooser = this.findBlockInside('b-chooser');

        this._actionsParams = this.params; // параметры блока
        this._currentActionName = this._actionsParams.defaultAction; // Идентификатор первой вкладки
        this._actionTitles = u['b-edit-groups-mass-actions'].getActionsTitles(); // заголовки блоков
        this.model = BEM.MODEL.getOrCreate({ name: 'b-edit-groups-mass-actions', id: 'campaign' });
        this._subMan = BEM.create('i-subscription-manager');
        this.maxLengthAudits = this._getLengthPixelAudits();

        // часть действий нужно блокировать, если среди выбранных объявлений есть баннер в Метро
        // список групп не для всех типов объявлений приходит
        this.isMassEditCpmGeoproduct = (this.params.groups || []).some(function(group) {
            return group.cpmGroupType === 'cpm_geoproduct';
        });

        this._subMan.on(this._chooser, 'change', function(e, data) {
            this._currentActionName = data.extraParams.name;
            this._onChooserChanged(this._currentActionName);
        }, this);

        this.hasMod('single') && this._subMan.wrap(BEM.MODEL)
            .on(this._actionsParams.modelName, 'bannersIds', 'change', function(e, data) {
                this.setMod('visible', data.value.length > 1 ? 'yes' : '');
            }, this);

        this._bindOnPopupHide(function() {
            this.model.rollback();
        }, this);

        this._onChooserChanged(this._currentActionName);
    },

    /**
     * Хранилище инпутов
     */
    _inputBlocks: {},

    /**
     * Хранилище селектов
     */
    _selectBlocks: {},

    /**
     * Хранилище обработчиков событий
     */
    _actions: {
        'add-sitelinks': function() {
            return this._addSitelinks();
        },

        'add-turbolandings': function() {
            return this._addTurbolandings();
        },

        'update-minus-words': function() {
            return this._addMinusWords();
        },

        'update-text': function() {
            return this._updateText();
        },

        'replace-domain': function() {
            return this._replaceDomain();
        },

        'new-href': function() {
            return this._setNewHref();
        },

        'replace-display-href': function() {
            return this._replaceDisplayHref();
        },

        'update-href': function() {
            return this._updateHrefPart();
        },

        'change-callouts': function() {
            return this._updateCallouts();
        },

        'remove-all-video': function() {
            return this._removeAllVideo();
        },

        'save-video': function() {
            return this._saveVideo();
        },

        'update-pixel-audience': function() {
            return this._updatePixelAudience();
        },

        'update-pixel-audits': function() {
            return this._updatePixelAudit();
        },

        'banner-pic-back': function() {
            return this._triggerPicActions('back');
        },

        'banner-pic-save': function() {
            this._sendActionToMetrika('banner-pic-save');

            return this._triggerPicActions('save');
        },

        creative: function() {
            return this._imageAdSelector.triggerSave();
        },

        cancel: function() {
            this.trigger('hide-popup');
        }
    },

    /**
     * Хранилище флагов о том, что данная вкладка проинициализирована
     */
    _isActionInited: {},

    /**
     * Хранилище функций, инициализирующих вкладки
     */
    _initActions: {
        'add-sitelinks': function() {
            this._sitelinks = this.findBlockInside('b-sitelinks-selector');
            this._sitelinksModel = BEM.MODEL.getOrCreate({ name: 'm-banner-sitelinks-multi', id: 'campaign' });

            this._sitelinksModel.fix();

            this
                ._bindOnSiteLinks()
                ._bindOnPopupHide(function() {
                    // откатываем несохраненное
                    this._sitelinksModel.rollback();
                }, this);

            this._isActionInited['add-sitelinks'] = true;
        },

        'add-turbolandings': function() {
            var updateBtnState = (function() {
                var mode = this._turbolandingsMode.val(),
                    selectedId = +(this._turbolandingsSelector.getValue() || {}).id,
                    isEnabled = mode === 'remove' || !!selectedId;

                this._checkPopupButton(isEnabled, 'add-turbolandings');
            }).bind(this);

            this._turbolandingsMode = this.findBlockOn(
                'turbolanding-change-mode',
                'radiobox');

            this._turbolandingsSelector = this.findBlockOn(
                'turbolandings-controls-selector',
                'b-turbo-landings-selector');

            this._subMan
                .on(this._turbolandingsMode, 'change', function(e, data) {
                    this._turbolandingsSelector.setMod('disabled', data.currentVal === 'add' ? '' : 'yes');
                    updateBtnState();
                }, this)
                .on(this._turbolandingsSelector, 'change', function() {
                    updateBtnState();
                }, this)
                .on(this, 'popup-shown', function() {
                    this._turbolandingsMode.val('add');
                    this._turbolandingsSelector.setValue();
                    updateBtnState();
                }, this);

            this._isActionInited['add-turbolandings'] = true;
        },

        'new-href': function() {
            this._getInput('new-href-input') && this._getInput('new-href-input').on('change', function(e, data) {
                if (data && data.striped) return;

                this._onNewHrefChange(e.block);
                this._isActionInited['new-href'] = true;
            }, this);

        },

        'pic-selector': function() {
            if (!this.findElem('action', 'type', 'pic-selector').length) return;

            this._initPicSelector();

            this._isActionInited['pic-selector'] = true;
        },

        creative: function() {
            if (!this.findElem('action', 'type', 'creative').length) return;

            if (!this._isActionInited['creative']) {
                if (u._.some(this._getStatOfCreative(), Boolean)) {
                    this
                        ._initImageAdSelector()
                        ._updateCreativeContent();

                    // следим за изменением изображения графического объявления на всех баннерах страницы
                    this._subMan.on(this, 'popup-shown', this._updateCreativeContent, this);
                } else {
                    this._getImageSelector().getImageLoader().model.set('needDisabled', true);
                }
            }

            this._isActionInited['creative'] = true;
        },

        callouts: function() {
            // При повторном открытии попапа нужно инициализировать блок уточнений заново
            this._subMan.on(this, 'popup-shown', function() {
                this._isActionInited['callouts'] = false;
                this._initCalloutsSelector();
                this._isActionInited['callouts'] = true;
            }, this);

            this._calloutsSelector || (this._calloutsSelector =
                this.findBlockInside({ block: 'b-callouts-selector', modName: 'mode', modVal: 'multi' }));

            this._subMan.on(this._calloutsSelector, 'change', function(e, data) {
                this._checkPopupButton(data.isChanged, 'change-callouts')
            }, this);

            this._initCalloutsSelector();

            this._isActionInited['callouts'] = true;
        },

        'replace-display-href': function() {
            this._subMan
                .on(this._getInput('replace-display-href-input'), 'change', function(e) {
                    var newDisplayHrefVal = e.block.val();

                    this.model.set('display_href', newDisplayHrefVal);

                    this.findElem('display-link-length-counter')
                        .text(20 - u.preview.skipSharpSign(this._getInput('display-href-inputs').val()).length);
                }, this)
                .on(this, 'popup-shown', function() {
                    this.model.set('display_href', this._getCommonDisplayHref()).fix();
                }, this);

            this._isActionInited['replace-display-href'] = true;
        },

        video: function() {
            this._updateVideoControlState();
            // считаем, сколько всего и сколько текстовых объявлений
            this._subMan.on(this, 'popup-shown', this._updateVideoControlState, this);
            this._subMan.wrap(this.findBlockInside('b-video-extension'))
                .on('show', function() {
                    this._checkPopupButton(false, 'save-video')
                }, this)
                .on('add', function(e, data) {
                    this._newVideo = data;
                    this._checkPopupButton(true, 'save-video');
                    this.delMod(this.elem('video-banner-chosen'), 'visibility');
                    this.elem('video-banner-chosen')
                        .text(iget2(
                            'b-edit-groups-mass-actions',
                            'videos-chosen',
                            'Выбрано видеодополнение «{name}»',
                            { name: data.name }
                        ));
                }, this);
        },
        'pixel-audit': function() {
            this._pixelAuditInputs = this.findBlocksInside('update-pixel-audits', 'input');

            this._isActionInited['pixel-audit'] = true;
        }

    },

    /**
     * привязываем события на закрытие попапа
     * @param {Function} callback - обработчик
     * @param {Object} context - контекст
     * @returns {BEM.DOM}
     * @private
     */
    _bindOnPopupHide: function(callback, context) {
        this._subMan.on(this, 'popup-hidden', callback.bind(context), this);

        return this;
    },

    /**
     * Реакция на изменения таба: открыть и, если надо, инициализировать панель
     * @param {String} currentActionName имя текущего таба
     * @private
     */
    _onChooserChanged: function(currentActionName) {
        this._openAction(currentActionName);

        this._initActions[currentActionName] && !this._isActionInited[currentActionName] &&
            this._initActions[currentActionName].call(this);
    },

    /**
     * Открывает новый таб
     * @param {String} action - открываемый таб
     * @private
     */
    _openAction: function(action) {
        var actionElem = this.findElem('action', 'type', action),
            buttonsGroupElem = this.findElem('buttons-group', 'type', action),
            actionTitleElem = this.findElem('action-title'),
            oldAction = this.getMod(this.findElem('action', 'show', 'yes'), 'type');

        this.delMod(this.findElem('action', 'show', 'yes'), 'show');
        this.delMod(this.findElem('buttons-group', 'show', 'yes'), 'show');

        if (actionElem.length) {
            this.setMod(actionElem, 'show', 'yes');
        } else {
            BEM.DOM.append(this.elem('action-panel'), BEMHTML.apply(
                u._.extend({
                    block: 'b-edit-groups-mass-actions',

                    elem: 'action',
                    elemMods: {
                        type: action,
                        show: 'yes'
                    }
                }, this._getActionContext(action))
            ));
        }

        if (buttonsGroupElem.length) {
            this.setMod(buttonsGroupElem, 'show', 'yes');
        } else {
            BEM.DOM.append(this.elem('buttons'), BEMHTML.apply({
                block: 'b-edit-groups-mass-actions',
                mods: {
                    type: this.getMod('type')
                },
                elem: 'buttons-group',
                action: action,
                elemMods: {
                    type: action,
                    show: 'yes'
                }
            }));
        }

        BEM.DOM.replace(actionTitleElem, BEMHTML.apply({
            block: 'b-edit-groups-mass-actions',
            elem: 'action-title',
            content: this._actionTitles[action]
        }));

        this
            ._initPopupButtons()
            ._bindTextInputs();

        this.setMod(this.elem('footer'), 'action', action);
        this._needRepaint(action, oldAction) && this.trigger('repaint');
    },

    /**
     * Возвращает набор параметров для текущего таба
     * @param {String} currentAction - текущий таб
     * @returns {Object}
     * @private
     */
    _getActionContext: function(currentAction) {
        var params = this._actionsParams,
            mediaType = params.mediaType,
            clientId = params.clientId,
            isMcbanner = mediaType === 'mcbanner',
            isCpmBanner = u.campaign.isCpm(mediaType);

        return {
            'add-sitelinks': {
                groups: params.groups,
                blockMods: mediaType === 'dynamic' ?
                    {
                        for: 'dynamic-banner'
                    } :
                    undefined,
                isTurbolandingsEnabled: params.isTurbolandingsEnabled,
                clientId: clientId
            },
            'add-turbolandings': {
                clientId: clientId,
                isMassEditCpmGeoproduct: this.isMassEditCpmGeoproduct,
                isCpmBanner: isCpmBanner
            },
            'pic-selector': {
                clientId: clientId,
                mediaType: mediaType,
                cid: params.cid,
                images: params.images
            },
            creative: {
                clientId: clientId,
                mediaType: mediaType,
                cid: params.cid,
                imageAdsGallery: params.imageAdsGallery || []
            },
            'href-part': {
                changeSitelinks: !(isMcbanner || isCpmBanner),
                canEditDomain: params.canEditDomain
            },
            'new-domain': {
                isSingle: params.isSingle
            },
            'new-href': {
                canEditDomain: params.canEditDomain
            },
            video: {
                clientId: clientId,
                strategy: params.strategy

            },
            'pixel-audit': {
                maxLength: this.maxLengthAudits
            }
        }[currentAction] || {}
    },

    _getLengthPixelAudits: function() {
        if (!this._groupsModels) {
            this._groupsModels = BEM.MODEL.get(this._actionsParams.modelName);
        }

        var isCpmVideoOrCpmBanner = this._groupsModels.some(function(group) {
            var groupAdType = group.get('cpmGroupType');

            return groupAdType === 'cpm_video' &&
                u.consts('rights').cpmVideoSeveralPixelsEnabled ||
                groupAdType === 'cpm_banner';
        });

        if (isCpmVideoOrCpmBanner) {
            return 4;
        }

        return 1;
    },

    /**
     * Возвращает true, если надо перерисовать попап
     * Дергается при переходе с/на действия с крупными контролами
     * @param {String} action - новое действие
     * @param {String} oldAction - старое действие
     * @returns {boolean}
     * @private
     */
    _needRepaint: function(action, oldAction) {
        var actionsToRepaint = ['callouts', 'sitelinks'];

        return u._.contains(actionsToRepaint, action) || u._.contains(actionsToRepaint, oldAction);
    },

    /**
     * Возвращает общую для всех баннеров отображаемую ссылку если она есть и пустую строку если у баннеров разные
     * общие ссылки
     * @returns {String}
     * @private
     */
    _getCommonDisplayHref: function() {
        var commonDisplayHref,
            isEqual = true;

        this._eachBannerModel('text', function(model, i) {
            var displayHref = model.get('display_href');

            if (i === 0) {
                commonDisplayHref = displayHref;
            } else {
                isEqual = isEqual && (displayHref === commonDisplayHref)
            }
        }, this);

        return isEqual ? commonDisplayHref : '';
    },

    /**
     * Событие изменения групповой ссылки на сайт
     * @param {BEM} block
     * @private
     */
    _onNewHrefChange: function(block) {
        var value = block.val(),
            protocol = u.getUrlProtocol(value);

        value && block.val(u.stripHttp(value), { striped: true });

        protocol && this._getSelect('new-href-protocol').val(protocol);

        this._checkPopupButton(!!value.length, 'new-href');

        this._subMan.on(this, 'popup-shown', function() {
            this._checkPopupButton(!!block.val().length, 'new-href');
        }, this);
    },

    /**
     * Подписывает на state блока b-sitelinks-selector
     * @returns {BEM.DOM}
     * @private
     */
    _bindOnSiteLinks: function() {
        this._sitelinks && this._subMan.on(this._sitelinks, 'state', this._onSiteLinksState, this);

        return this;
    },

    /**
     * Активирует/деактивирует кнопки попапа в зависимости от состояния
     * колбек события state блока b-sitelinks-selector
     * @param {Object} e
     * @param {Object} [data]
     * @returns {Boolean}
     * @private
     */
    _onSiteLinksState: function(e, data) {
        var button = this.findBlockOn(this.findElem('popup-button', 'action', 'add-sitelinks'), 'button');

        // иногда валидация сайтлинков проходит с запозданием и кнопки уже нет
        data && button && button.setMod('disabled', data.state === 'valid' ? '' : 'yes');

        return false;
    },

    /**
     * Инициализирует блок загрузки изображения
     * @private
     */
    _initPicSelector: function() {
        this._picSelector = this.findBlockInside('b-pic-selector');
        this._picSelectorModel = this._picSelector && this._picSelector.getImageModel();

        this
            ._bindOnPicSelector()
            ._bindOnPopupHide(function() {
                // откатываем несохраненное
                this._picSelector && this._picSelector.declineChange();
            }, this);

        return this;
    },

    /**
     * Подписывает на события блока b-pic-selector
     * @returns {BEM.DOM}
     * @private
     */
    _bindOnPicSelector: function() {
        if (!this._picSelector) return this;

        this._subMan.wrap(this._picSelector)
            .on('cancel', function() {
                this.trigger('hide-popup');
            }, this)
            .on('button-state-changed', function(e, buttonsStates) {
                u._.forOwn(buttonsStates, function(disabledState, actionType) {
                    // приходят инвертированные значения, где true == disabled
                    this._checkPopupButton(!disabledState, 'banner-pic-' + actionType)
                }, this);
            }, this);

        this._subMan.on(this._picSelectorModel, 'update clear', function() {
            if (!this._getEditableBanners('image_model').length ||
                this._picSelectorModel.get('image_processing_state') === 'pending') {
                return false;
            }

            this._changeBannerPic();
        }, this);

        return this;
    },

    /**
     * Дергает кнопки на блоке выбора изображения
     * @param {String} type - тип действия
     * @returns {boolean}
     * @private
     */
    _triggerPicActions: function(type) {
        this._picSelector && this._picSelector.triggerButton(type);

        return false;
    },

    _imageAdSelector: null,

    _getImageSelector: function() {
        return this._imageAdSelector ||
            (this._imageAdSelector = this.findBlockOn(this.elem('image-ad-selector'), 'b-image-ad-selector'));
    },

    /**
     * Инициализирует блок загрузки графического объявления
     * @private
     */
    _initImageAdSelector: function() {
        var imageAdSelector = this._getImageSelector();

        if (!imageAdSelector) {
            return this;
        }

        this._subMan.wrap(imageAdSelector)
            .on('button-state-changed', function(e, isDisabled) {
                this._checkPopupButton(isDisabled, 'creative');
            }, this)
            .on('change', function(e, data) { return this._onImageAdSelectChanged(data); }, this)
            .on('cancel', function() { this.trigger('hide-popup'); }, this)
            .on('select', function(e, data) { this._onImageAdSelect(data); }, this);

        this._subMan.wrap(imageAdSelector.getImageLoader())
            .on('_loading_*', function(e, data) {
                e.block.model.set('needDisabled', !!data.modVal);
            });

        if (u['b-image-add-loader'].getAvailableItems(this.params.mediaType).cpcVideoAllowed) {
            this._subMan.wrap(imageAdSelector.getImageLoader())
                .on('ready', function(e, data) {
                    var bannerStorage = data.bannerStorage;

                    bannerStorage.postMessage({
                        type: 'video-addition-preview',
                        data: {}
                    });
                });
        }

        this._bindOnPopupHide(function() {
            // откатываем несохраненное
            imageAdSelector.reset();
        });

        return this;
    },

    _statOfCreative: null,

    /**
     * Возращает статистику по креативам только у сохранненых объявлений
     * @returns {Object}
     * @private
     */
    _getStatOfCreative: function() {
        if (!this._statOfCreative) {
            var stat = {
                images: 0,
                creatives: 0,
                cpmGeoProduct: 0,
                cpmVideoCreatives: 0,
                cpmAudioCreatives: 0,
                cpcVideoCreatives: 0
            };

            // считаем, сколько и каких объявлений в группе
            this._eachBannerModel(function(model) {
                var banner = model.toJSON(),
                    isImage = !u['b-image-add-loader'].isEmptyImage(banner.image_ad),
                    isCreative = !u['b-image-add-loader'].isEmptyCreative(banner.creative),
                    isGeoProductCreative = model.getParentModel().get('cpmGroupType') === 'cpm_geoproduct',
                    isVideoCreative = u['b-image-add-loader'].isVideoCreative(banner.creative);

                if (!banner.isNewBanner) {

                    if (isImage) {
                        ++stat.images;
                    } else if (isCreative) {

                        if (isGeoProductCreative) {
                            ++stat.cpmGeoProduct;
                        } else if (isVideoCreative) {
                            if (banner.ad_type === 'cpc_video') {
                                ++stat.cpcVideoCreatives;
                            } else if (model.getParentModel().get('cpmGroupType') === 'cpm_audio') {
                                ++stat.cpmAudioCreatives;
                            } else {
                                ++stat.cpmVideoCreatives;
                            }
                        } else {
                            ++stat.creatives;
                        }
                    }
                }

                    // else if (banner.isNewBanner) {
                    // // Если есть новые объявления без креативов
                    // // показываем возможные варианты
                    // if (banner.ad_type === 'cpc_video') {
                    //     ++stat.cpcVideoCreatives;
                    // } else if (model.getParentModel().get('cpmGroupType') === 'cpm_video') {
                    //     ++stat.cpmVideoCreatives;
                    // } else if (banner.ad_type === 'image_ad') {
                    //     ++stat.images;
                    //     ++stat.creatives;
                    // }
            });

            this._statOfCreative = stat;

        }

        return this._statOfCreative;
    },

    /**
     * Обновляет текст заголовка блока выбора графического объявления
     * @param {Object} [data]
     * @param {String|'image_ad'|'creative'} [data.type] тип выбранных объекта
     * @param {Object[]} [data.selectedData] выбранные объекты
     * @param {Number} [data.changedCount] количество изображений, которые будут изменены
     * @private
     */
    _updateCreativeContent: function(data) {
        var obj = data || {},
            stat = this._getStatOfCreative(),
            title,
            mediaType = this.params.mediaType;

        title = u['b-image-ad-selector'].getTitle(mediaType, obj.changedCount);

        this._imageAdSelector.setTitle(title);
        this._imageAdSelector.setHint({
            mediaType: mediaType,
            stat: stat,
            selectedData: obj.selectedData
        });

        this._updateCreativeItems(stat);
    },

    _updateCreativeItems: function(stat) {
        var items = [];

        stat.images && items.push('images');
        stat.creatives && items.push('creatives');
        stat.cpmVideoCreatives && items.push('video');
        stat.cpmAudioCreatives && items.push('audio');
        stat.cpcVideoCreatives && items.push('cpc-video');
        stat.cpmGeoProduct && items.push('geoproduct');

        this._imageAdSelector.getImageLoader().updateItemStates(items);
    },

    /**
     * Возвращает adType для действий с креативами и изображениями
     * @returns {String}
     * @private
     */
    _getImageBannerAdType: function() {
        // для ТГО модель изображения имеет ad_type: image_ad
        // для ГО на поиске - mcbanner
        return this.getMod('type') === 'mcbanner' ? 'mcbanner' : 'image_ad';
    },

    /**
     * Проверки при выборе клиентом изображения/группы креативов
     * @private
     */
    _onImageAdSelectChanged: function(data) {
        var errorMessage,
            suitableFormatBannersNum = 0,
            ambigousBannerImage = 0,
            selectedData = data.images || data.creatives || [],
            type = data.images ? 'image_ad' : (data.creatives ? 'creative' : undefined);

        this._eachBannerModel(function(model) {
            var banner = model.toJSON(),
                suitableForBanner = 0;

            // количество изображений/креативов, подходящих для текущего баннера
            selectedData.forEach(function(obj) {
                this._isImageSuitableForBanner(banner, obj, type) && suitableForBanner++;
            }, this);

            // подходит ли хотя бы что-нибудь для текущего баннера
            !!suitableForBanner && suitableFormatBannersNum++;
            suitableForBanner > 1 && ambigousBannerImage++;
        }, this);

        if (!suitableFormatBannersNum) {
            // нет примененных изображений
            errorMessage = selectedData.length > 1 ?
                iget2(
                    'b-edit-groups-mass-actions',
                    'razmery-vybrannyh-kreativov-ne',
                    'Размеры выбранных креативов не соответствуют размерам ни одного из графических объявлений на этой странице'
                ) :
                iget2(
                    'b-edit-groups-mass-actions',
                    'razmery-vybrannogo-kreativa-ne',
                    'Размеры выбранного креатива не соответствуют размерам ни одного из графических объявлений на этой странице'
                );

            this._showErrorMessage(errorMessage);

            return false;
        }

        if (ambigousBannerImage) {
            // для какого-то из баннеров подходит более одного изображения
            this._showErrorMessage(iget2(
                'b-edit-groups-mass-actions',
                'pri-massovom-izmenenii-mozhno',
                'При массовом изменении можно выбрать только одно изображение для каждого размера'
            ));

            return false;
        }

        this._updateCreativeContent({
            type: type,
            selectedData: selectedData,
            changedCount: suitableFormatBannersNum
        });
    },

    /**
     * Обработчик события сохранения клиентом изображения для графического баннера
     * @param {Object} data данные нового изображения
     * @private
     */
    _onImageAdSelect: function(data) {
        var imageAdBannersNum = 0,
            suitableFormatBannersNum = 0,
            selectedData = data.images || data.creatives || [],
            type = data.images ? 'image_ad' : (data.creatives ? 'creative' : undefined),
            unselectedObjectType = data.images ? 'creative' : (data.creatives ? 'image_ad' : undefined),
            isMcbanner = this.getMod('type') === 'mcbanner',
            message;

        this._eachBannerModel(function(model) {
            var banner = model.toJSON();

            imageAdBannersNum++;

            // количество изображений/креативов, подходящих для текущего баннера
            selectedData.forEach(function(selected) {

                if (this._isImageSuitableForBanner(banner, selected, type)) {
                    suitableFormatBannersNum++;

                    if (unselectedObjectType && model.hasField(unselectedObjectType)) {
                        model.get(unselectedObjectType).clear();
                    }

                    type && model.get(type).update(selected);
                }
            }, this);
        }, this);

        if (isMcbanner) {
            message = iget2(
                'b-edit-groups-mass-actions',
                'success-warning-creative-of-mcb',
                'Во всех баннерах изменены подходящие по размеру графические креативы');
        } else if (type === 'creative' && selectedData[0].creative_type === 'video_addition') {
            if ((selectedData[0].canvas_tags || []).indexOf('cpm_audio') !== -1) {
                message = iget2(
                    'b-edit-groups-mass-actions',
                    'success-warning-audio-creative',
                    'Во всех аудиообъявлениях, изменен аудиокреатив');
            } else {
                message = iget2(
                    'b-edit-groups-mass-actions',
                    'success-warning-video-creative',
                    'Во всех видеообъявлениях, изменен видеокреатив');
            }
        } else {
            message = iget2(
                'b-edit-groups-mass-actions',
                'success-warning-creative',
                'Во всех графических объявлениях изменены подходящие по размеру графические креативы');
        }

        message && this._showMessage(message, function() {
            this.trigger('hide-popup');
        });
    },

    /**
     * Определяет можно ли заменить изображение/креатив в баннере на соответствующее новое
     * @param {Object} banner информация о баннере
     * @param {Object} selected данные нового изображения/креатива
     * @param {'image_ad'|'creative'} type тип нового изображения/креатива
     * @private
     */
    _isImageSuitableForBanner: function(banner, selected, type) {
        var current = banner[type],
            compareSizes = current && +(current.width) === +(selected.width) &&
                +(current.height) === +(selected.height),
            cpmVideoAddition;

        if (banner.isNewBanner) return false;

        if (u._.get(banner, 'creative.is_adaptive') === '1' || selected.is_adaptive === '1') {
            return u._.get(banner, 'creative.is_adaptive') === selected.is_adaptive;
        }

        switch (type) {
            case 'creative':
                // Делаем замену только для сохраненных банеров
                // этот код пусть пока полежит
                // if (banner.isNewBanner) {
                //     // video_addition
                //     // html5_creatives
                //     // canvas
                //     if (current.creative_type) {
                //         return current.creative_type === selected.creative_type;
                //     } else {
                //         switch (selected.creative_type) {
                //             case 'canvas':
                //                 return banner.ad_type === 'image_ad' || cpmGroupType === 'cpm_banner';
                //             case 'video_addition':
                //                 return cpmGroupType === 'cpm_video' || banner.ad_type === 'cpc_video';
                //             case 'html5_creatives':
                //                 return cpmGroupType === 'cpm_banner';
                //             default:
                //                 return false;
                //         }
                //     }
                // } else {

                cpmVideoAddition = ['cpm_video', 'cpm_audio', 'cpm_indoor', 'cpm_outdoor']
                    .some(function(type) {
                        return current.cpmSubtype === type;
                    });

                // [video_addition] creative_type
                if (current.creative_type === selected.creative_type) {
                    if (cpmVideoAddition) {
                        return (selected.canvas_tags || [])
                            .indexOf(current.cpmSubtype === 'cpm_video' ? 'cpm' : current.cpmSubtype) !== -1;
                    } else {
                        return compareSizes;
                    }
                }

                // [canvas|html5_creative] creative_type
                if (['canvas', 'html5_creative'].indexOf(selected.creative_type) !== -1 &&
                        ['canvas', 'html5_creative'].indexOf(current.creative_type) !== -1) {
                    return compareSizes;
                }

                return false;

            case 'image_ad':
                return compareSizes;

            default:
                return compareSizes;
        }
    },

    /**
     * Привязка событий при изменении текстовых полей
     * @private
     */
    _bindTextInputs: function() {
        [
            'href-from',
            'new-domain-input',
            'text-from',
            'add-minus-words',
            'replace-display-href-input',
            'update-pixel-audience'
        ].forEach(function(item) {
            var input = this._getInput(item);
            if (input) {
                this._subMan.on(input, 'change', function(e) {
                    var inputBlock = e.block;

                    this._checkPopupButton(!!inputBlock.val().length, inputBlock.params.forAction);
                }, this);
            }
        }, this);

        return this;
    },

    /**
     * Инициализирует события клика на кнопках попапа
     * @returns {BEM}
     * @private
     */
    _initPopupButtons: function() {
        this.findBlocksOn(this.findElem('popup-button'), 'button').forEach(function(btn) {
            btn.un('click');

            this._subMan.on(btn, 'click', function(e) {
                this._onPopupButtonClick(e.block);
            }, this);
        }, this);

        return this;
    },

    /**
     * Выставляет модификатор action
     * колбек нажатия кнопок внутри попапа
     * @param {BEM} btn
     * @private
     */
    _onPopupButtonClick: function(btn) {
        var action = this.getMod(btn.domElem, 'action'),
            result = this._actions[action] && this._actions[action].call(this);

        if (result !== false) {
            btn.setMod('focused', '');
            this.trigger('hide-popup');

            this._sendActionToMetrika(action);
        }
    },

    _sendActionToMetrika: function(action) {
        if (this.hasMod('type', 'text')) {
            BEM.blocks['b-metrika2'].params({
                params: {
                    'text-multiedit-mass-actions': {
                        action: action
                    }
                }
            });
        }
    },

    /**
     * Заменить ссылку всех баннеров
     * @returns {Boolean} флаг, управляющий скрытием попапа по завершению действия
     * (true - в случае, если попап нужно закрыть)
     * @private
     */
    _setNewHref: function() {
        var replaceDomainCheckbox = this.findBlockOn('replace-domain', 'checkbox'),
            newValue = this._getInput('new-href-input').val(),
            protocol = this.findBlockInside('new-href-protocol', 'select').val(),
            bUtils = BEM.blocks['i-utils'],
            data = {
                href: newValue,
                url_protocol: protocol
            },
            errMsg = !newValue ? iget2('b-edit-groups-mass-actions', 'vvedite-novuyu-ssylku', 'Введите новую ссылку') : '';

        if (!this._getEditableBanners('href').length) {
            return false;
        }

        if (errMsg || !u.isUrl(newValue)) {
            this._showErrorMessage(errMsg || iget2('b-edit-groups-mass-actions', 'vvedennyy-vami-url-ne', 'Введенный Вами URL не работает'));

            return false;
        }

        if (replaceDomainCheckbox && replaceDomainCheckbox.isChecked()) {
            data.domain = bUtils.parseUrl(newValue).host;
        }

        this._eachBannerModel(function(model) {
            model.get('href_model').update(data);
        });

        this._getInput('new-href-input').val('');
        this._getSelect('new-href-protocol').val('https://');

        return true;
    },

    /**
     * Инициализирует блок выбора уточнений
     * @private
     */
    _initCalloutsSelector: function() {
        var calloutsKits = [];

        this._eachBannerModel('text', function(bannerModel, i) {
            calloutsKits[i] = bannerModel.get('callouts');
        }, this);

        // Дизейблим кнопку при каждом открытии попапа
        this._checkPopupButton(false, 'change-callouts');

        // Блокируем кнопку сохранения, если блок уточнений не валиден
        this._subMan.on(this._calloutsSelector, 'change', function(e, data) {
            this._checkPopupButton(data.isChanged && data.isValid, 'change-callouts');
        }, this);

        this._calloutsSelector.reset({ calloutsKits: calloutsKits });
    },

    /**
     * Умно обновляет модели баннеров выбранными в блоке уточнениями
     * @returns {Boolean} флаг, управляющий скрытием попапа по завершению действия
     * (true - в случае, если попап нужно закрыть)
     * @private
     */
    _updateCallouts: function() {
        var calloutsKits = (this._calloutsSelector.val() || {}).calloutsKits;

        if (!this._getEditableBanners('callouts').length) {
            return false;
        }

        this._eachBannerModel('text', function(bannerModel, i) {
            bannerModel.set('callouts', calloutsKits[i]);
        }, this);

        return true;
    },

    /**
     * Обработчик нажатия на кнопку сохранения видеодополнений
     * @private
     */
    _saveVideo: function() {
        var video = this._newVideo;

        this._eachBannerModel('text', function(model) {
            model.set('video_resources', video);
        });

        this._showMessage(iget2(
            'b-edit-groups-mass-actions',
            'videos-added',
            'Ко всем текстово-графическим объявлениям добавлено видеодополнение «{name}»',
            { name: this._newVideo.name }
        ), function() {
            this.trigger('hide-popup');
            this._sendActionToMetrika('save-video');
        });

        return false;
    },

    _updateVideoControlState: function() {
        var textBannersCount = 0,
            allBannersCount = 0,
            bannersWithVideo = 0,
            text;

        this._eachBannerModel(function(model) {
            var video = model.get('video_resources');

            allBannersCount++;
            model.get('ad_type') === 'text' && textBannersCount++;
            video && !u._.isEmpty(video) && bannersWithVideo++;
        });

        text = u.pluralForms(
            iget2('b-edit-groups-mass-actions',
                'video-budet-dobavleno-stolko-iz-stolkim banneram',
                'Видеодополнения будут добавлены в {textBannersCount} {объявление|объявления|объявлений} из {allBannersCount}.',
                {
                    textBannersCount: textBannersCount,
                    allBannersCount: allBannersCount
                }
            ),
            textBannersCount
        );

        this.elem('video-banners-count').text(text);

        this.findBlockInside('b-video-extension').toggleMod('disabled', '', 'yes', textBannersCount > 0);
        this._checkPopupButton(bannersWithVideo > 0, 'remove-all-video');
    },

    /**
     * Удаление всех видеодополнений
     * @private
     */
    _removeAllVideo: function() {
        this._eachBannerModel('text', function(model) {
            model.clear('video_resources');
        });

        this._showMessage(iget2(
            'b-edit-groups-mass-actions',
            'videos-deleted',
            'Видеодополнения удалены у всех текстово-графических объявлений'
        ), function() {
            this.trigger('hide-popup');
        });

        return false;
    },

    /**
     * Обновляет поле «Пиксель Я.Аудиторий» всем баннерам
     * @private
     */
    _updatePixelAudience: function() {
        var newValue = $.trim(this._getInput('update-pixel-audience').val());

        this._eachBannerModel(function(bannerModel) {
            bannerModel.set('audience', newValue);
        });

        this._getInput('update-pixel-audience').val('');
    },

    /**
     * Обновляет поле «Счётчик показов» всем баннерам
     * @private
     */
    _updatePixelAudit: function() {
        var newValue = this._pixelAuditInputs;

        newValue = newValue.map(function(item) {
            return $.trim(item.val());
        });

        this._eachBannerModel(function(bannerModel) {
            var cpmGroupType = bannerModel.getParentModel().get('cpmGroupType');

            if (cpmGroupType === 'cpm_video' && !u.consts('rights').cpmVideoSeveralPixelsEnabled ||
                cpmGroupType !== 'cpm_banner') {
                bannerModel.update({ audits: newValue.slice(0, 1) });
                return;
            }
            bannerModel.update({ audits: newValue });
        });

        this._pixelAuditInputs.forEach(function(item) {
            item.val('');
        });
    },

    /**
     * Применяет callback к модели каждой группы на странице редактирования групп
     * @param {Function} callback
     * @param {Object} ctx
     * @returns {BEM}
     * @private
     */
    _eachGroupModel: function(callback, ctx) {
        if (!this._groupsModels) {
            this._groupsModels = BEM.MODEL.get(this._actionsParams.modelName);
        }

        this._groupsModels.forEach(function(group) {
            callback.call(ctx, group);
        });

        return this;
    },

    /**
     * Применяет callback к модели каждого баннера на странице редактирования групп
     * @param {String} [arg1] тип баннеров к которым нужно применить callback (по умолчанию применяется ко всем)
     * @param {Function} arg2 callback-функция
     * @param {Object} [arg3] контекст выполнения callback-функции
     * @returns {BEM}
     * @private
     */
    _eachBannerModel: function(arg1, arg2, arg3) {
        var bannerType,
            callback,
            ctx;

        if (typeof arg1 === 'string') {
            bannerType = arg1;
            callback = arg2;
            ctx = arg3;
        } else {
            callback = arg1;
            ctx = arg2;
        }

        if (!this._groupsModels) {
            this._groupsModels = BEM.MODEL.get(this._actionsParams.modelName);
        }

        var i = 0;

        this._groupsModels.forEach(function(group) {
            group.getBanners().forEach(function(banner) {
                var bannerAdType = banner.get('ad_type') || 'text';

                if (bannerType && bannerType !== bannerAdType) {
                    return;
                }

                callback.call(ctx, banner, i++);
            });
        });

        return this;
    },

    /**
     * Заменить часть ссылки всех баннеров
     * @returns {Boolean} флаг, управляющий скрытием попапа по завершению действия
     * (true - в случае, если попап нужно закрыть)
     */
    _updateHrefPart: function() {
        var hrefFromInput = this._getInput('href-from'),
            hrefToInput = this._getInput('href-to'),
            hrefFrom = hrefFromInput.val(),
            hrefTo = hrefToInput.val(),
            regexp = new RegExp(this._regexpEscape(hrefFrom), 'gi'),
            updateHrefParams = {
                pattern: regexp,
                replacement: hrefTo,
                hrefFromInput: hrefFromInput,
                hrefToInput: hrefToInput
            },
            invalidDomains = [],
            replaced = [],
            message;

        if (!this._getEditableBanners('href').length) {
            return false;
        }

        if (!hrefFrom) {
            this._showErrorMessage(iget2('b-edit-groups-mass-actions', 'vvedite-stroku-dlya-poiska', 'Введите строку для поиска'));

            return false;
        }

        this._eachBannerModel(function(model) {
            var hrefModel = model.get('href_model'),
                sitelinksModel = model.get('sitelinks');

            if (!hrefModel.isEmpty('href') && hrefModel.get('href').match(regexp)) {
                replaced.push(hrefModel.get('href').replace(regexp, hrefTo));
            }

            if (this._needToUpdateSiteLinks(model)) {
                for (var i = 0; i < CONSTS.SITELINKS_NUMBER; i++) {
                    if (!sitelinksModel.isEmpty('href' + i) && sitelinksModel.get('href' + i).match(regexp)) {
                        replaced.push(sitelinksModel.get('href' + i).replace(regexp, hrefTo));
                    }
                }
            }
        }, this);

        if (!replaced.length) {
            this._showErrorMessage(iget2('b-edit-groups-mass-actions', 'ne-nayden-fragment-dlya', 'Не найден фрагмент для замены.'));

            return false;
        }

        replaced.length && replaced.forEach(function(href) {
            if (!u.isUrl(href)) {
                invalidDomains.push(href);
            }
        });

        if (invalidDomains.length > 0) {
            message = iget2(
                'b-edit-groups-mass-actions',
                'posle-izmeneniya-chast-ssylok',
                'После изменения часть ссылок не будет работать. Продолжить?'
            ); // DIRECT-31008

            this._showConfirm(message, function() {
                this._updateHref(updateHrefParams);
                this.trigger('hide-popup');
                this._sendActionToMetrika('update-href');
            });
        } else {
            this._updateHref(updateHrefParams);
            this.trigger('hide-popup');
            this._sendActionToMetrika('update-href');
        }

        return false;
    },

    /**
     * @param {BEM<i-model>} bannerModel модель баннера
     * @returns {Boolean} если true то нужно обновить быстрые ссылки баннеров
     * @private
     */
    _needToUpdateSiteLinks: function(bannerModel) {
        // быстрые ссылки не надо заменять в графических объявлениях
        var isImageAd = this._isImageAd(bannerModel);

        return !isImageAd && this.findBlockOn('update-sitelinks', 'checkbox').isChecked();
    },

    /**
     * Обновляет ссылку на сайт и быстрые ссылки
     *
     * @param {Object} data
     * @private
     */
    _updateHref: function(data) {
        var domain = this.findBlockOn('update-domain', 'checkbox'),
            updateDomain = domain && domain.isChecked();

        this._eachBannerModel(function(model) {
            var params = {
                banner: model,
                pattern: data.pattern,
                replacement: data.replacement
            };

            this._changeBannerHref(params, updateDomain);
            this._needToUpdateSiteLinks(model) && this._updateBannerSiteLinks(params);
        }, this);

        data.hrefFromInput.val('');
        data.hrefToInput.val('');
    },

    /**
     * Обновляет ссылку на сайт
     * @param {Object} params
     * @param {Boolean} updateDomain
     * @private
     */
    _changeBannerHref: function(params, updateDomain) {
        var hrefModel = params.banner.get('href_model'),
            isImageAd = this._isImageAd(params.banner),
            newHref = hrefModel.get('href').replace(params.pattern, params.replacement),
            updateHref = {
                href: newHref
            },
            url = BEM.blocks['i-utils'].parseUrl(newHref);

        updateDomain && !isImageAd && (updateHref.domain = url.host);

        hrefModel.update(updateHref);
    },

    /**
     * Обновляет быстрые ссылки
     * @param {Object} params
     * @private
     */
    _updateBannerSiteLinks: function(params) {
        var banner = params.banner,
            sitelinksModel = banner.get('sitelinks'),
            siteLinks = {},
            i = 0;

        for (; i < CONSTS.SITELINKS_NUMBER; i++) {
            if (!sitelinksModel.isEmpty('href' + i)) {
                siteLinks['href' + i] = sitelinksModel.get('href' + i).replace(params.pattern, params.replacement);
            }
        }

        sitelinksModel.update(siteLinks).fix();
    },

    /**
     * Заменяет отображаемую ссылку в моделях баннера
     * @returns {Boolean} флаг, управляющий скрытием попапа по завершению действия
     * (true - в случае, если попап нужно закрыть)
     * @private
     */
    _replaceDisplayHref: function() {
        var newDisplayHref = this.model.get('display_href'),
            validationResult,
            errorText;

        if (!this._getEditableBanners('display_href').length) {
            return false;
        }

        validationResult = this.model.validate();

        if (validationResult.valid) {
            if (this.model.isEmpty('display_href')) {
                this._showConfirm(
                    iget2(
                        'b-edit-groups-mass-actions',
                        'vnimanie-otobrazhaemaya-ssylka-budet',
                        'Внимание! Отображаемая ссылка будет удалена у всех выбранных объявлений.'
                    ),
                    function() {
                        this._eachBannerModel('text', function(model) {
                            model.update({ display_href: newDisplayHref });
                        }, this);

                        this.trigger('hide-popup');

                        this._sendActionToMetrika('replace-display-href');
                    });
            } else {
                this._eachBannerModel('text', function(model) {
                    model.update({ display_href: newDisplayHref });
                }, this);

                this.trigger('hide-popup');

                this._sendActionToMetrika('replace-display-href');
            }
        } else {
            errorText = validationResult.errorsData['display_href'].map(function(error) {
                return error.text
            }).join('. ');
            this.findElem('replace-display-href-error').text(errorText);
        }

        return false;
    },

    /**
     * Заменяет домен в моделях баннера
     * @returns {Boolean} флаг, управляющий скрытием попапа по завершению действия
     * (true - в случае, если попап нужно закрыть)
     * @private
     */
    _replaceDomain: function() {
        var newDomain = this._getInput('new-domain-input').val(),
            isWholeCampElem = this.findBlockOn('whole-camp', 'checkbox'),
            isWholeCamp = isWholeCampElem && isWholeCampElem.isChecked();

        if (!this._getEditableBanners('new-domain').length) {
            return false;
        }

        if (!newDomain) {
            this._showErrorMessage(iget2('b-edit-groups-mass-actions', 'vvedite-novyy-domen', 'Введите новый домен'));
            return false;
        }

        if (!u.isUrl(newDomain)) {
            this._showErrorMessage(iget2('b-edit-groups-mass-actions', 'vvedennyy-vami-url-ne', 'Введенный Вами URL не работает'));
            return false;
        }

        this._eachBannerModel('text', function(model) {
            model.get('href_model').update({
                domain: newDomain,
                domain_sign: '',
                domain_redir: '',
                domain_redir_sign: ''
            });
        }, this);

        this._getInput('new-domain-input').val('');

        isWholeCamp && BEM.MODEL.getOne({ name: 'm-campaign' }).set('camp_banners_domain', newDomain).fix();

        return true;
    },

    /**
     * Заменяет совпавшую часть текста в title и body моделей баннеров
     * @private
     */
    _updateText: function() {
        var textFrom = this._getInput('text-from').val(),
            textTo = this._getInput('text-to').val(),
            regexp = new RegExp(this._regexpEscape(textFrom).replace(/\s/gi, '\\s'), 'gi'),
            isTextChanged = false;

        if (!this._getEditableBanners('text').length) {
            return false;
        }

        if (!textFrom) {
            this._showErrorMessage(iget2('b-edit-groups-mass-actions', 'vvedite-stroku-dlya-poiska', 'Введите строку для поиска'));

            return false;
        }

        this._eachBannerModel('text', function(model) {
            if (!isTextChanged && (regexp.test(model.get('body') || '') || regexp.test(model.get('title') || '') ||
                    regexp.test(model.get('title_extension') || ''))) {
                isTextChanged = true;
            }

            model.update({
                title: (model.get('title') || '').replace(regexp, textTo),
                body: (model.get('body') || '').replace(regexp, textTo),
                title_extension: (model.get('title_extension') || '').replace(regexp, textTo)
            });
        }, this);

        if (!isTextChanged) {
            this._showErrorMessage(iget2('b-edit-groups-mass-actions', 'ne-nayden-fragment-dlya', 'Не найден фрагмент для замены.'));

            return false;
        }

        this._getInput('text-from').val('');
        this._getInput('text-to').val('');

        return true;
    },

    /**
     * Добавляет минус слова ко фразам баннера
     * @private
     */
    _addMinusWords: function() {
        var newMinusWord = u.minusWords.stringToArray(this._getInput('add-minus-words').val()),
            errors = { spaceFlag: 0 },
            phrase;

        if (u.minusWords.isEmpty(newMinusWord)) {
            this._showErrorMessage(iget2('b-edit-groups-mass-actions', 'vvedite-minus-slova', 'Введите минус слова'));

            return false;
        }

        this._eachGroupModel(function(model) {
            BEM.MODEL.get({ name: 'm-phrase-text', parentModel: model }).forEach(function(phraseModel) {
                this._updatePhraseMinusWords(
                    phraseModel,
                    this._processMinusWord(phraseModel.get('phrase'), newMinusWord, errors)
                );
            }, this);
        }, this);

        if (errors.spaceFlag) {
            this._showErrorMessage(iget2('b-edit-groups-mass-actions', 'minus-slova-ne-mogut', 'Минус-слова не могут состоять из нескольких слов!'));

            return false;
        } else if (errors.deprecatedWordsHash) {
            var errorText = iget2(
                'b-edit-groups-mass-actions',
                'nelzya-vychitat-slova-soderzhashchiesya',
                'Нельзя вычитать слова, содержащиеся в исходной ключевой фразе. Например, нельзя вычитать слово "кино", содержащиеся в исходной ключевой фразе "билет в кино"'
            );

            for (phrase in errors.deprecatedWordsHash) {
                errorText +=
                    '\n' +
                    iget2('b-edit-groups-mass-actions', 'minus-slovo-s-est', 'Минус-слово "{foo}" есть в следующих ключевых фразах "{bar}"', {
                        foo: phrase,
                        bar: errors.deprecatedWordsHash[phrase].join(', ')
                    });
            }
            this._showErrorMessage(errorText);

            return false;
        } else {
            this._getInput('add-minus-words').val('');

            return true;
        }
    },

    /**
     * Обновляет минул слова м модели фразы
     * @param {BEM.MODEL} phraseModel
     * @param {Array} minusWords
     * @private
     */
    _updatePhraseMinusWords: function(phraseModel, minusWords) {
        phraseModel.set(
            'minus_words',
            u._.unique(phraseModel.get('minus_words').concat(minusWords)),
            { source: 'multiedit' }
        );

        phraseModel.fix();
    },

    /**
     * Добавляет быстрые ссылки баннера
     * @returns {Boolean} флаг, управляющий скрытием попапа по завершению действия
     * (true - в случае, если попап нужно закрыть)
     * @private
     */
    _addSitelinks: function() {
        var isAnyBannerHaveSitelink = false;

        if (!this._getEditableBanners('sitelinks').length) {
            return false;
        }

        this._eachBannerModel('text', function(banner) {
            if (!banner.get('sitelinks').isEmpty()) {
                isAnyBannerHaveSitelink = true;
            }
        }, this);

        if (isAnyBannerHaveSitelink && this._sitelinksModel.isEmpty()) {
            this._showConfirm(
                iget2(
                    'b-edit-groups-mass-actions',
                    'bystrye-ssylki-budut-udaleny',
                    'Быстрые ссылки будут удалены на всех баннерах'),
                function() {
                    this._updateSitelinks();
                    this.trigger('hide-popup');
                }
            );
            return false;
        } else {
            this._updateSitelinks();
            return true;
        }
    },

    /**
     * обновляет сайтлинки по всем баннерам
     * @private
     */
    _updateSitelinks: function() {
        var data = this._sitelinks.getJSON();
        this._sitelinksModel
            .update(data)
            .fix();

        this._eachBannerModel('text', function(model) {
            model.get('sitelinks').update(data);
            model.get('sitelinks').fix();
        }, this);
    },

    /**
     * Добавляет турбо-страницы
     * @returns {Boolean} флаг, управляющий скрытием попапа по завершению действия (true - в случае, если попап нужно
     *     закрыть)
     */
    _addTurbolandings: function() {
        var isAnyBannerHaveTurbolanding = false,
            mode = this._turbolandingsMode.val(),
            data = mode === 'add' ? this._turbolandingsSelector.getValue() : { id: '0' };

        if (!this._getEditableBanners('turbolanding').length) {
            return false;
        }

        this._eachBannerModel('text', function(banner) {
            if (!banner.get('turbolanding').isEmpty()) {
                isAnyBannerHaveTurbolanding = true;
            }
        }, this);

        if (isAnyBannerHaveTurbolanding && !Number(data.id)) {
            this._showConfirm(
                iget2(
                    'b-edit-groups-mass-actions',
                    'turbo-will-be-removed-from-all-ads',
                    'Турбо-страницы будут удалены у всех объявлений.'),
                function() {
                    this._updateTurbolandings(data);
                    this.trigger('hide-popup');
                }
            );

            return false;
        } else {
            this._updateTurbolandings(data);
            return true;
        }
    },

    /**
     * обновляет турбостраницы по всем баннерам
     * @param {Object} data
     * @private
     */
    _updateTurbolandings: function(data) {
        var turbolandingField = this.isMassEditCpmGeoproduct ? 'turbolandingGeoproduct' : 'turbolanding';

        this._eachBannerModel(function(model) {
            data.id ? model.set(turbolandingField, data) : model.get(turbolandingField).clear();
            model.get(turbolandingField).fix();
        }, this);
    },

    /**
     * Обновляет поля image, image_name, image_type, source_image, image_source_url
     * всех моделей баннера при изменении модели m-banner-pic
     * @private
     */
    _changeBannerPic: function() {
        var bannerPicModel = this._picSelectorModel.toJSON(),
            message = u._.some(this._picSelectorModel.toJSON(), Boolean) ?
                iget2(
                    'b-edit-groups-mass-actions',
                    'success-warning-image-add',
                    'Ко всем текстово-графическим объявлениям добавлено изображение') :
                iget2(
                    'b-edit-groups-mass-actions',
                    'success-warning-image-remove',
                    'Изображения удалены у всех текстово-графических объявлений');

        this._eachBannerModel('text', function(model) {
            model.get('image_model').update(bannerPicModel);
        });

        this._showMessage(message, function() {
            this.trigger('hide-popup');
        });
    },

    /**
     * Формирует фразы баннера с минус словами
     *
     * @param {String} fullPhrase фраза с минус словами
     * @param {Array} minusWords минус слова
     * @param {Object} errors коллектор ошибок
     * @returns {Array}
     * @private
     */
    _processMinusWord: function(fullPhrase, minusWords, errors) {
        var processedMinusWords = [],
            phraseWords = u.phraseFormatter.getKeyWords(fullPhrase.toLowerCase()).split(' ');

        minusWords.forEach(function(minusWord) {
            // DIRECT-51480
            // логика актуальна пока минус-фразы доступны только на группу и кампанию
            if (minusWord.indexOf(' ') > -1) {
                errors.spaceFlag = 1;
            }

            if (this._doesMinusWordDeprecated(fullPhrase, phraseWords, minusWord, errors)) {
                errors.deprecatedWordsHash[minusWord] || (errors.deprecatedWordsHash[minusWord] = []);

                errors.deprecatedWordsHash[minusWord].push(fullPhrase);

            } else if (minusWord !== '') {
                processedMinusWords.push(minusWord);
            }
        }, this);

        return processedMinusWords;
    },

    /**
     * Проверяет можно ли добавить к фразам переданное минус-слово
     *
     * @param {String} fullPhrase фраза с минус словами
     * @param {Array} phraseWords фраза без минус-слов разбитая по пробелам
     * @param {String} minusWord  проверяемое слово
     * @param {Object} errors коллектор ошибок
     * @returns {Boolean}
     * @private
     */
    _doesMinusWordDeprecated: function(fullPhrase, phraseWords, minusWord, errors) {
        if (phraseWords.indexOf(minusWord) === -1) {
            return false;
        }

        errors.deprecatedWordsHash || (errors.deprecatedWordsHash = {});

        return !errors.deprecatedWordsHash[minusWord] ||
            $.inArray(fullPhrase, errors.deprecatedWordsHash[minusWord]) < 0;
    },

    /**
     * Показывает окно подтверждения
     * @param {String} message
     * @param {Function} onConfirm обработчик клика по кнопке подтверждения
     * @param {Function} onCancel обработчик клика по кнопке подтверждения
     * @private
     */
    _showConfirm: function(message, onConfirm, onCancel) {
        BEM.blocks['b-user-dialog'].confirm({
            message: message,
            onConfirm: onConfirm,
            onCancel: onCancel,
            callbackCtx: this
        }, this);
    },

    /**
     * Показывает ошибки в окне сообщения
     * @param {String} message
     */
    _showErrorMessage: function(message) {
        BEM.blocks['b-user-dialog'].alert({
            message: message
        });
    },

    /**
     * Показывает сообщение в модальном окне.
     * @param {String} message текст сообщения
     * @param {Function|undefined} onClose обработчик клика по кнопке закрытия
     * @private
     */
    _showMessage: function(message, onClose) {
        BEM.blocks['b-user-dialog'].alert({
            message: message,
            onCancel: onClose,
            callbackCtx: this
        });
    },

    /**
     * Экранирует строку для использования в регулярном выражении
     * @param {String} input
     * @returns {String}
     * @private
     */
    _regexpEscape: function(input) {
        return u.escape.regExp(input);
    },

    /**
     * Находит блок инпута по name-му
     * @param {String} name
     * @returns {BEM/false}
     * @private
     */
    _getInput: function(name) {
        return this.findElem(name) ?
            (this._inputBlocks[name] = this.findBlockOn(name, 'input')) :
            false;
    },

    /**
     * Находит блок селекта по name-му
     * @param {String} name
     * @returns {BEM/false}
     * @private
     */
    _getSelect: function(name) {
        return this.findElem(name) ?
            (this._selectBlocks[name] = this.findBlockOn(name, 'select')) :
            false;

    },

    /**
     * При необходимости дизейблит кнопку действия
     * @param {Boolean} value флаг про наличие значения
     * @param {String} action имя действия
     * @private
     */
    _checkPopupButton: function(value, action) {
        var button = this.findElem('popup-button', 'action', action);

        button.each(function(index, elem) {
            this.findBlockOn($(elem), 'button').setMod('disabled', value ? '' : 'yes');
        }.bind(this));
    },

    /**
     * Определяет является ли тип объявления у баннера графическим
     * @param {BEM<i-model>} bannerModel модель баннера
     * @return {Boolean}
     * @private
     */
    _isImageAd: function(bannerModel) {
        var adType = bannerModel.get('ad_type');

        return adType === 'image_ad' || adType === 'mcbanner' || adType === 'cpc_video';
    },

    /**
     * Находит все баннеры, для которых разрешено редактирование указанного поля.
     * Выводит ошибку, в случае если таких баннеров нет.
     * @param {String} fieldName имя редактируемого поля
     * @returns {Array} массив моделей баннеров, для которых разрешено редактирование указанного поля
     */
    _getEditableBanners: function(fieldName) {
        var allBanners = [],
            bannersByType = {
                imageAd: [],
                common: []
            },
            result = [],
            errorMessage;

        this._eachBannerModel(function(bannerModel) {
            allBanners.push(bannerModel);

            bannersByType[this._isImageAd(bannerModel) ? 'imageAd' : 'common'].push(bannerModel);
        }, this);

        if (fieldName === 'href' || fieldName === 'tracking-href' || fieldName === 'turbolanding') {
            result = allBanners;
        } else if (!bannersByType.common.length) {
            errorMessage = iget2(
                'b-edit-groups-mass-actions',
                'dannye-izmeneniya-nedostupny-dlya',
                'Данные изменения недоступны для графических объявлений'
            );
        } else {
            result = bannersByType.common;
        }

        if (errorMessage) {
            this._showErrorMessage(errorMessage);
        }

        return result;
    },

    _changeInput: function(e) {
        var inputBlock = e.block;

        if (this.findElem('input', 'type', 'input-pixel-audit').is(inputBlock.domElem)) {
            var hasValue = this._pixelAuditInputs.some(function(input) {
                return !!input.val();
            });

            this._checkPopupButton(hasValue, inputBlock.params.forAction);
        }
    }
}, {

    live: function() {

        this.liveInitOnBlockInsideEvent('change', 'input', function(e) {
            this._changeInput(e);
        });
    }
});
