# b-edit-groups-mass-actions
Блок массовых действий над объявлениями.

## Объявление
Объявляется в блоке `p-multiedit2__mass-actions.bemtree.js`.
Отдельно объявляется сам блок, ему обязательно надо передать `js: id`:
```
block: 'b-edit-groups-mass-actions',
js: {
    id: 'mass-actions'
},
mods: {
    type: type, // mediaType
    single: isSingleGroup ? 'yes' : 'no', // 1 группа или несколько
    visible: (!isSingleGroup || isSingleGroup && campaign.groups[0].banners.length > 1) ? 'yes' : '' // при 1 баннере блок не нужен
}
```

Отдельно объявляется элемент `controls`:
```
applyCtx({
    block: 'b-edit-groups-mass-actions',
    mods: { type: type },
    elem: 'controls',
    clientId: clientId,
    isSingleGroup: isSingleGroup
})
```

Для каждого типа кампаний в .bemtree добавляются нужные ему параметры.

## Модификаторы
Модификатор соответствует типу кампании и добавляет к общим данным блока специфические именно для него. Также в модификаторах
написан специфический js и css

## Структура блока
1. Блок состоит из 3 смысловых компонент:
- `__chooser`: выбор массового действия
- `__action`: само действие
- `__buttons`: кнопки сохранения и отмены

### Элемент __chooser
Использует блок `b-chooser`. При клике на действие дергается событие `change`, по которому открывается действие.

### Элемент __action
Имеет модификатор _type для каждого возможного действия. По событию `change` на `__chooser` скрипт находит элемент с
выбранным модификатором (`__action_type_new-href`, например) и ставит ему модификатор `show: yes`. Если такого элемента
нет, то добавляет его в DOM; это сделано потому, что многие сложные блоки (типа `b-pic-selector`) некорректно дестрактятся.

Данные для действия пробрасываются через js элемента `content` (b-edit-groups-mass-actions.bemhtml.js) и метод `getActionContext`

### Элемент __buttons
Для каждого действия имеет моду, которая задает набор и характеристики контролов в футере. Для вкладки изображения/креатив
(`action_type_pic-selector`) используется подвал внутреннего блока
