block('b-edit-groups')(

    def()(function() {
        return applyNext({
            targetGroupBlock: u.consts('rights').ajaxAdGroupsMultiSave ? 'b-edit-group-2' : 'b-edit-group'
        });
    }),

    addJs()(function() {
        return {
            isSingleGroup: this.ctx.isSingleGroup,
            targetGroupBlock: this.targetGroupBlock
        };
    }),

    content()(function() {
        return applyCtx([
            {
                elem: 'groups',
                type: this.ctx.type,
                errorPath: this.ctx.errorPath,
                isSingleGroup: this.ctx.isSingleGroup,
                hasMediaResources: this.ctx.hasMediaResources
            },
            this.data.prev_banner && {
                elem: 'prev-banner'
            },
            !this.ctx.isSingleGroup && {
                elem: 'floater',
                headerType: this.ctx.headerType
            }
        ]);
    }),

    elem('groups').def()(function() {
        var data = this.data,
            ctx = this.ctx,
            targetGroupBlock = this.targetGroupBlock,
            feeds = data.feeds,
            type = ctx.type,
            isSingleGroup = ctx.isSingleGroup,
            bannersStatus = data.FORM.banner_status,
            errorPathBuilder = u.error.createPathBuilder(ctx.errorPath);

        return (data.campaign.groups || []).map(function(group, index) {
            return {
                block: targetGroupBlock,
                mods: {
                    type: type
                },
                groupIndex: index,
                errorPath: errorPathBuilder(index),
                firstBanner: group.banners[0],
                isSingleGroup: isSingleGroup,
                campaign: data.campaign,
                group: group,
                feeds: feeds,
                canEditDomain: hasLoginRights('super_control', 'support_control', 'placer_control', 'manager_control'),
                bannersStatus: bannersStatus,
                isAutoVideoOn: !!data.auto_video,
                hasMediaResources: ctx.hasMediaResources,
                clientId: data.campaign.ClientID,
                isTurboLandingEnabled: Boolean(data.is_featureTurboLandingEnabled),
                promoCodeDomains: data.promocode_domains
            };
        });
    }),

    elem('prev-banner')(

        def()(function() {
            return {
                elem: 'prev-banner'
            };
        }),

        // у динамических объявлений нет копирования из предыдущего баннера
        match(function() {
            return this.ctx.type === 'dynamic-full';
        }).def()('')
    ),

    elem('floater').def()(function() {
        return {
            block: 'b-floater',
            mix: {
                block: 'b-edit-groups',
                elem: 'floater'
            },
            mods: {
                to: 'top',
                iterate: 'yes',
                theme: 'khaki',
                natural: 'yes',
                resizable: 'yes'
            },
            content: {
                elem: 'inner',
                content: {
                    block: 'b-edit-group-header',
                    mods: this.ctx.headerType && {
                        type: this.ctx.headerType
                    }
                }
            }
        };
    }),

    elem('prev-banner').def()(function() {
        return {
            block: 'i-model-aggregator',
            content: [
                {
                    block: 'i-model',
                    modelParams: {
                        name: 'm-banner',
                        id: 'prev',
                        data: u.bannerModelData({
                            banner: u.bannerData({
                                banner: this.data.prev_banner
                            }),
                            loadVCardFromClient: true
                        })
                    }
                },
                this.data.prev_banner.vcard && {
                    block: 'i-model',
                    modelParams: {
                        name: 'm-vcard',
                        id: 'prev',
                        parentName: 'm-banner',
                        parentId: 'prev',
                        data: this.data.prev_banner.vcard
                    }
                }
            ]
        };
    })
);
