BEM.DOM.decl('b-edit-groups', {
    onSetMod: {
        js: function() {
            //если группа одна - то плашку не показываем
            !this.params.isSingleGroup && this._initFloatingHeader();

        }
    },

    /**
     * Превращает строку-заголовок таблицы в плавающую (манипуляции с DOM)
     * @private
     */
    _initFloatingHeader: function() {
        this.floater = this.findBlockOn('floater', 'b-floater');

        this._floaterHeader = this.floater.findBlockInside('b-edit-group-header');

        this.floater.init({
            rows: this.findBlocksInside(this.params.targetGroupBlock)
                .map(function(block) { return block.findBlockInside('b-edit-group-header') }),
            onDone: this._updateGroupInfo.bind(this)
        });

    },

    /**
     *
     * @param {BEM} bemRow элемент b-edit-group-header по которому заполняем floater
     * @private
     */
    _updateGroupInfo: function(bemRow) {
        this._floaterHeader.setGroupModelParams(bemRow.getGroupModelParams());
    }
});
