/**
 * @event b-edit-interests-targeting-item#delete
 * @type {Object}
 * @property {String} id идентификатор категории интереса для удаления
 *
 * @fires b-edit-interests-targeting-item#delete событие нажатия на кнопку удаления категории интереса
 */

BEM.DOM.decl({ block: 'b-edit-interests-targeting-item' }, {
    onSetMod: {
        js: function() {
            this._deleteBtn = this.findBlockOn('delete', 'button');

            this._deleteBtn && this._deleteBtn.on('click', this._onDeleteButtonClicked, this);
        }
    },

    /**
     * Удаляет блок и подписки на события
     */
    destruct: function() {
        this._deleteBtn && this.findBlockOn('delete', 'button').un('click', this._onDeleteButtonClicked);

        return this.__base.apply(this, arguments);
    },

    /**
     * Обработчик события нажатия на кнопку удаления
     * @private
     */
    _onDeleteButtonClicked: function() {
        this.trigger('delete', { id: this.params.id });
    }
});
