block('b-edit-metrics-key-goals-item')(
    js()(function() {
        return {
            value: this.ctx.value,
            goals: this.ctx.goals,
            currency: this.ctx.currency,
            selectedGoalId: this.ctx.selectedGoalId
        };
    }),

    mix()(function() {
        var ctx = this.ctx;

        return applyNext({
            'ctx.mix': [].concat(ctx.mix).concat([{
                block: 'i-glue',
                js: {
                    modelName: 'b-edit-metrics-key-goals-item',
                    modelId: String(ctx.id),
                    modelData: {
                        goalId: ctx.selectedGoalId,
                        price: ctx.price,
                        currency: ctx.currency,
                        status: ctx.status,
                        isDefault: ctx.isDefault,
                        isSingle: ctx.isSingle
                    }
                }
            }])
        });
    }),

    content()(function() {
        var goals = this.ctx.goals,
            selectedGoal = goals[this.ctx.selectedGoalId];

        return [
            {
                elem: 'item-index',
                content: this.ctx.index + '.'
            },
            {
                block: 'b-metrics-goal-selector',
                mods: {
                    error: selectedGoal && selectedGoal.status === u.goals.GOAL_STATUS.deleted ? 'yes' : ''
                },
                mix: [
                    {
                        block: 'b-edit-metrics-key-goals-item',
                        elem: 'item-value',
                        elemMods: { 'item-id': this.ctx.id }
                    }
                ],
                goals: goals,
                selectedGoalId: this.ctx.selectedGoalId,
                disabledGoalsIds: this.ctx.disabledGoalsIds
            },
            {
                block: 'button',
                mods: {
                    size: 'xs',
                    theme: 'icon',
                    'only-icon': 'yes'
                },
                mix: {
                    block: 'b-edit-metrics-key-goals-item',
                    elem: 'delete',
                    elemMods: {
                        'delete-enabled': this.ctx.isDeleteEnabled ? 'yes' : ''
                    }
                },
                attrs: {
                    title: iget2('b-edit-metrics-key-goals-item', 'delete', 'Удалить')
                },
                content: {
                    block: 'icon',
                    mods: {
                        'size-16': 'delete',
                        theme: 'light'
                    },
                    mix: {
                        block: 'button',
                        elem: 'icon'
                    }
                }
            },
            {
                elem: 'price',
                content: [
                    {
                        elem: 'price-label',
                        content: iget2('b-edit-metrics-key-goals-item', 'price-label', 'Ценность конверсии')
                    },
                    {
                        block: 'input',
                        mix: [
                            {
                                block: 'b-edit-metrics-key-goals-item',
                                elem: 'price-control',
                            },
                            {
                                block: 'i-glue',
                                elem: 'model-field',
                                js: {
                                    name: 'price',
                                    type: 'input'
                                }
                            }
                        ],
                        value: u.numberFormatter.format(this.ctx.price),
                        content: [
                            {
                                elem: 'control'
                            }
                        ]
                    },
                    {
                        elem: 'price-currency',
                        content: u.currencies.getName(this.ctx.currency)
                    }
                ]
            }
        ]
    })
)
