BEM.DOM.decl({ block: 'b-edit-metrics-key-goals-item' }, {
    onSetMod: {
        js: function() {
            this._goalId = this.params.selectedGoalId;
            this._model = this.findBlockOn('i-glue').model;
            this._price = this.findBlockOn('price-control', 'input');
            this._goalSelector = this.findBlockOn('item-value', 'b-metrics-goal-selector');
            this._deleteBtn = this.findBlockOn('delete', 'button');
            this._parentModel = BEM.MODEL.getOne({ name: 'b-edit-metrics-key-goals', id: '0' });
            this._subscriptionManager = BEM.create('i-subscription-manager');

            this._subscriptionManager
                .on(this._goalSelector, 'change', this._onItemGoalIdChange, this)
                .on(this._deleteBtn, 'click', this.destruct, this);

            this._subscriptionManager
                .wrap(this._price)
                .on('change', this._setHasChanges, this)
                .on('focus', this._clearError, this);

            this._subscriptionManager
                .wrap(this._parentModel)
                .on('itemsCount', 'change', this._onItemsCountChange, this)
                .on('selectedGoalIds', 'change', this._updateDisabledGoals, this)
                .on('hasErrors', 'change', this._dropError, this);
        }
    },

    _getItemsCount: function() {
        return this._parentModel.get('itemsCount');
    },

    _setItemsCount: function(value) {
        return this._parentModel.set('itemsCount', value);
    },

    _getSelectedGoalIds: function() {
        return this._parentModel.get('selectedGoalIds');
    },

    _setSelectedGoalIds: function(value) {
        return this._parentModel.set('selectedGoalIds', value);
    },

    _goalIdFilterFn: function(goalId) {
        return goalId !== this._goalId;
    },

    destruct: function() {
        this._subscriptionManager.dispose();
        this._subscriptionManager.destruct();

        this._setItemsCount(this._getItemsCount() - 1);
        this._setSelectedGoalIds(
            this._getSelectedGoalIds().filter(this._goalIdFilterFn.bind(this))
        );
        this.__base.apply(this);
    },

    /**
     * Метод, проверяющий контрол на валидность
     * */
    validate: function() {
        var validationResult = this._model.validate(),
            isValid = validationResult.valid,
            errors = validationResult.errors;

        this._price.setMod('error', !isValid ? 'yes' : '');
        if (!errors) {
            return [];
        }

        return (errors.map(function(err) {
            return err.text;
        }));
    },

    /**
     * Метод, устанавливающий признак отсутствия ошибок в родительском контроле
     * */
    _clearError: function() {
        this._parentModel.set('hasErrors', false);
    },

    /**
     * Обработчик события сброса ошибки в контроле
     * */
    _dropError: function(event, hasErrorsField) {
        if (!hasErrorsField.value) {
            this._price.setMod('error', '');
        }
    },

    /**
     * Метод, устанавливающий признак наличия изменений в родительском контроле
     * */
    _setHasChanges: function() {
        this._parentModel.set('hasChanges', true);
    },

    /**
     * Обработчик события изменения цели в одном из элементов
     **/
    _onItemGoalIdChange: function(event, data) {
        var newValue = data.value,
            goal = this.params.goals[newValue],
            status = goal.status,
            isDefault = goal.isDefault,
            newGoalIds;

        this._model.update({
            goalId: newValue,
            status: status,
            isDefault: isDefault,
            isSingle: this._getItemsCount() === 1
        });

        newGoalIds = this._getSelectedGoalIds()
            .filter(this._goalIdFilterFn.bind(this))
            .concat([newValue]);

        this._goalId = newValue;

        this._setSelectedGoalIds(newGoalIds);

        this.setMod(this._price, 'error', status === u.goals.GOAL_STATUS.deleted ? 'yes' : '');
    },

    /**
     * Обработчик события изменения общего числа элементов в списке ключевых целей
     **/
    _onItemsCountChange: function(event, itemsCountField) {
        this._updateDeleteBtn(itemsCountField);
        this._model.set('isSingle', itemsCountField.value === 1);
    },

    /**
     * Метод, устанавливающий нужный модификатор на кнопку удаления элемента
     **/
    _updateDeleteBtn: function(itemsCountField) {
        var elem = this.elem('delete');

        if (itemsCountField.value > 1) {
            this.setMod(elem, 'delete-enabled', 'yes');
        } else {
            this.setMod(elem, 'delete-enabled', '');
        }
    },

    /**
     * Метод, устанавливающий список дизейбленых элементов в селекторе типа ключевых целей
     **/
    _updateDisabledGoals: function(event, modelField) {
        this._goalSelector.updateGoalsAvailability(modelField.value.filter(this._goalIdFilterFn.bind(this)));
    }
});
