BEM.MODEL.decl({ model: 'b-edit-metrics-key-goals-item' }, {
    currency: 'string',
    isDefault: 'boolean',
    isSingle: 'boolean',

    goalId: {
        type: 'string',
        validation: {
            rules: {
                required: {
                    text: iget2('b-edit-metrics-key-goals-item', 'required-goal-id', 'Выберите цель'),
                    validate: function(val) {
                        return val !== '';
                    }
                }
            }
        }
    },

    status: {
        type: 'string',
        validation: {
            rules: {
                notDeleted: {
                    validate: function(val) {
                        return val !== 'Deleted';
                    }
                }
            }
        }
    },

    price: {
        type: 'optional-blank-number',
        default: '',
        precision: 2,
        validation: {
            rules: {
                lte: {
                    value: function() {
                        return u.currencies.getConst(this.get('currency'), 'MIN_AUTOBUDGET_BID');
                    },
                    text: function() {
                        return iget2('b-edit-metrics-key-goals-item', 'price-lte-error', 'Ценность конверсии не может быть меньше {boundary}', {
                            boundary: u.currencies.formatConst(this.get('currency'), 'MIN_AUTOBUDGET_BID')
                        });
                    },
                    needToValidate: function(val) {
                        return Boolean(val);
                    }
                },
                gte: {
                    value: function() {
                        return u.currencies.getConst(this.get('currency'), 'MAX_AUTOBUDGET');
                    },
                    text: function() {
                        return iget2('b-edit-metrics-key-goals-item', 'price-gte-error', 'Указана слишком большая ценность конверсии');
                    },
                    needToValidate: function(val) {
                        return Boolean(val);
                    }
                },
                required: {
                    text: iget2('b-edit-metrics-key-goals-item', 'required-goal-price', 'Укажите ценность конверсии'),
                    validate: function(val) {
                        if (this.get('isDefault') && this.get('isSingle')) {
                            return true;
                        }
                        return val !== undefined;
                    }
                }
            }
        }
    }
});
