/**
 * @param {Array<{goalId: String, price: Number}>} value информация о выбранных целях
 * @param {Object.<Goal>} goals
 * @param {String} currency
 **/
block('b-edit-metrics-key-goals')(
    js()(function() {

        return {
            value: this.ctx.value,
            goals: this.ctx.goals,
            currency: this.ctx.currency
        };
    }),

    mix()(function() {
        var ctx = this.ctx;

        return applyNext({
            'ctx.mix': [].concat(ctx.mix).concat([{
                block: 'i-glue',
                js: {
                    modelName: 'b-edit-metrics-key-goals',
                    modelId: '0',
                    modelData: {
                        itemsCount: ctx.value.length,
                        selectedGoalIds: this.ctx.value.map(function(item) {
                            return item.goalId;
                        }),
                        hasChanges: false,
                        hasErrors: false
                    }
                }
            }])
        });
    }),

    content()(function() {
        var goals = this.ctx.goals,
            value = this.ctx.value,
            currency = this.ctx.currency,
            valueGoalIds = value.map(function(valueItem) {
                return valueItem.goalId;
            });

        return [
            {
                elem: 'items',
                content: value.length ?
                    value.map(function(valueItem, index) {
                        var disabledGoalsIds = valueGoalIds.slice();

                        disabledGoalsIds.splice(disabledGoalsIds.indexOf(valueItem.goalId), 1);

                        return {
                            block: 'b-edit-metrics-key-goals-item',
                            mix: [
                                { block: 'b-edit-metrics-key-goals', elem: 'item', elemMods: { id: index } }
                            ],
                            isDeleteEnabled: value.length > 1,
                            goals: goals,
                            id: index,
                            index: index + 1,
                            price: valueItem.price,
                            selectedGoalId: valueItem.goalId,
                            disabledGoalsIds: disabledGoalsIds,
                            status: goals[valueItem.goalId].status,
                            currency: currency,
                            isDefault: goals[valueItem.goalId].isDefault,
                            isSingle: value.length === 1
                        }
                    }) :
                    {
                        block: 'b-edit-metrics-key-goals-item',
                        mix: [
                            { block: 'b-edit-metrics-key-goals', elem: 'item', elemMods: { id: '0' } }
                        ],
                        goals: goals,
                        id: 0,
                        status: 'Active',
                        index: 1,
                        isDeleteEnabled: false,
                        currency: currency
                    }
            },
            {
                elem: 'add',
                elemMods: {
                    hidden: value.length === Object.keys(goals).length ? 'yes' : ''
                },
                content: [
                    {
                        block: 'icon',
                        mods: { 'size-16': 'plus' },
                        mix: { block: 'b-edit-metrics-key-goals', elem: 'add-icon' }
                    },
                    iget2('b-edit-metrics-key-goals', 'add-goal', 'Добавить цель')
                ]
            },
            {
                elem: 'error'
            }
        ];
    })
);
