/**
 * @fires b-edit-param-button#click событие нажатия на кнопку
 */
BEM.DOM.decl('b-edit-param-button', {

    onSetMod: {
        js: function() {
            this._button = this.findBlockOn('button', 'button');

            this._button && this._button.on('click', function() {
                this.trigger('click');
            }, this);
        }
    },

    /**
     * Обновляет описание под кнопкой и текст кнопки
     * @param {BEMJSON} paramsSignJson содержимое подписи (в зависимости от наличия параметра меняется также текст кнопки)
     */
    updateParamsSign: function(paramsSignJson) {
        this._button && this.elem('switcher-text').text(paramsSignJson ? iget2('b-edit-param-button', 'izmenit', 'Изменить') : iget2('b-edit-param-button', 'dobavit-105', 'Добавить'));

        BEM.DOM.update(
            this.elem('params-sign'),
            paramsSignJson ? BEMHTML.apply(paramsSignJson) : this.params.emptyText
        );
    },

    /**
     * Удаляет блок и подписки на события
     */
    destruct: function() {
        this._button && this._button.un('click');

        return this.__base.apply(this, arguments);
    }
});
