/**
 * @params {Object} campModelParams
 */
block('b-edit-phrase-price-inline')(

    def()(function() {
        var ctx = this.ctx,
            phrase = ctx.phrase,
            strategy = ctx.strategy,
            isDifferentPlacesStrategy = strategy.name === 'different_places',
            contents = [],
            /**
             * Форматирование суммы
             * @param {String|Number}
             */
            formatSumOfMoney = function(val) {
                return u.currencies.formatSum(ctx.currency, val);
            };

        phrase.campDMName = ctx.campModelParams;

        if (phrase.is_retargeting) {
            if (phrase.price_context) {
                isDifferentPlacesStrategy && contents.push('&mdash;&nbsp;/&nbsp;');

                contents.push({
                    elem: 'link',
                    elemMods: {
                        type: 'context'
                    },
                    content: formatSumOfMoney(phrase.price_context),
                    type: 'context'
                });
            }
        } else if (phrase.is_relevance_match) {
            if (phrase.price) {

                contents.push({
                    elem: 'link',
                    elemMods: {
                        type: 'search'
                    },
                    content: formatSumOfMoney(phrase.price),
                    type: 'search'
                });
            }
        } else {
            if (phrase.price && strategy.search && strategy.search.name != 'stop') {
                contents.push({
                    elem: 'link',
                    elemMods: {
                        type: 'search'
                    },
                    content: formatSumOfMoney(phrase.price),
                    type: 'search'
                });
            }

            if (phrase.price_context && isDifferentPlacesStrategy) {
                contents.length || contents.push('&mdash;');

                contents.push('&nbsp;/&nbsp;', {
                    elem: 'link',
                    elemMods: {
                        type: 'context'
                    },
                    content: formatSumOfMoney(phrase.price_context),
                    type: 'context'
                });
            }
        }

        if (contents.length) {
            ctx.items = contents;
        }

        return applyNext();
    }),

    match(function() {
        return this.ctx.items;
    })(

        addJs()(function() {
            return u._.pick(this.ctx, ['currency', 'phrase', 'campModelParams']);
        }),

        content()(function() {
            return this.ctx.items.concat({
                block: 'spin',
                mix: [{
                    block: 'b-edit-phrase-price-inline',
                    elem: 'spin'
                }],
                js: true,
                mods: {
                    theme: 'gray-16'
                }
            });
        })
    ),

    elem('link').wrap()(function() {
        return {
            block: 'link',
            mods: {
                pseudo: 'yes'
            },
            mix: [{
                block: 'b-edit-phrase-price-inline',
                elem: 'link',
                elemMods: this.ctx.elemMods
            }],
            content: this.ctx.content
        };
    })
);
