BEM.DOM.decl('b-edit-phrase-price-inline', {

    onSetMod: {
        js: function() {
            var modelName;

            this._currency = this.params.currency;
            this._phrase = this.params.phrase;

            this._spin = this.findBlockOn('spin', 'spin');

            modelName = this._phrase.is_retargeting ?
                'm-retargeting-bidable' :
                this._phrase.is_interest ?
                    'm-interest-bidable' :
                    this._phrase.is_relevance_match ?
                        'm-relevance-match' :
                        'm-phrase-bidable';

            // при фиксации правок
            BEM.MODEL.on({ name: modelName, id: this._phrase.id }, 'fix', function(e, data) {
                if (data && data.ignore) return;

                // просим обновить текст ссылок
                this.setMod(this.elem('link'), 'pending-update', 'yes');

                // закрываем попап
                this._getPopup().hide();
            }, this);
        }
    },

    onElemSetMod: {
        link: {
            'pending-update': {
                yes: function(elem, modName, modVal) {
                    // обновляем текст ссылки
                    this._updateLinkText(this.getMod(elem, 'type'));

                    this.afterCurrentEvent(function() {
                        this.delMod(elem, modName);
                    }, this);
                }
            }
        }
    },

    /**
     * Действия, происходящие после клика на контрол открытия попапа
     */
    togglePopup: function(link) {
        var spin = this._spin,
            promise;

        link.setMod('disabled', 'yes');
        spin.setMod('progress', 'yes');

        promise = this.__self._fetchStatData(this._phrase.bannerId, this.params.campModelParams);

        promise
            .always(function() {
                link.delMod('disabled');
                spin.delMod('progress');
            })
            .then(this.changeThis(function(data) {
                var popup = this._getPopup();

                popup.setContent(this._getPopupContent(data), function() {
                    popup.toggle(link);
                });
            }, this));
    },

    /**
     * Возвращает модель фразы (либо m-retargeting-bidable, либо m-phrase-bidable)
     * @returns {BEM.MODEL}
     * @private
     */
    _getModel: function() {
        var modelParams,
            phrase = this._phrase;

        if (this._model) return this._model;

        modelParams = {
            name: phrase.is_retargeting ?
                'm-retargeting-bidable' :
                phrase.is_interest ?
                    'm-interest-bidable' :
                    phrase.is_relevance_match ?
                        'm-relevance-match' :
                        'm-phrase-bidable',
            id: phrase.id
        };

        this._model = BEM.MODEL.getOne(modelParams) || BEM.MODEL.create(modelParams, phrase);

        if (this._model) {
            this._model
                .update(u._.pick(phrase, ['bannerId', 'phrase']))
                .fix({ ignore: true });
        }

        return this._model;
    },

    /**
     * Изменяет текст ссылки после изменения модели
     * @param {String} controlType
     * @returns {BEM}
     */
    _updateLinkText: function(controlType) {
        var model = this._getModel(),
            fieldName = BEM.DOM.blocks['b-edit-phrase-price'].getFieldName(controlType),
            value = model && model.get(fieldName, 'format');

        this
            .findBlockOn(this.elem('link', 'type', controlType), 'link')
            .elem('inner')
            .text(u.formatSumOfMoney(this._currency, value));
    },

    /**
     * Возвращает экземпляр попапа
     * @returns {BEM}
     * @private
     */
    _getPopup: function() {
        if (this._popup) return this._popup;

        this._popup = BEM.blocks['b-shared-popup'].getInstance(
            {
                size: 'xs',
                animate: 'yes',
                // диалоговый попап, закрывается только по крестику или действию
                autoclosable: 'no',
                'has-close': 'yes'
            },
            {
                directions: ['right-middle-middle', 'top-center-right', 'bottom-center-right']
            });

        this._popup.on('hide', function() {
            this._getModel().rollback();
        }, this);

        return this._popup;
    },

    /**
     * Возвращает верстку содержимого попапа
     * @param {Object} data
     * @returns {String}
     * @private
     */
    _getPopupContent: function(data) {
        var model = this._getModel(),
            premium = model.get('premium'),
            guarantee = model.get('guarantee'),
            campaignFields = [
                'day_budget', 'spent_today', 'sum_rest',
                'timetarget_coef', 'strategy', 'autobudget',
                'autobudget_bid', 'mediaType', 'is_bs_rarely_loaded'
            ],
            phrasePlaces = ['pmax', 'pmax2', 'pmin', 'max', 'min', 'broker', 'min_price', 'context_coverage', 'cbroker'],
            auctionData = {
                premium: premium,
                guarantee: guarantee
            };

        return BEMHTML.apply({
            block: 'b-edit-phrase-price-popup',
            phrase: this._phrase,
            campDMParams: this.params.campModelParams,
            isRetargeting: this._phrase.is_retargeting,
            isRelevanceMatch: this._phrase.is_relevance_match,
            campaignData: u._.pick(data.campaign, campaignFields),
            currency: this._currency,
            priceForCoverage: model.get('price_for_coverage'),
            formattedCurrency: u.formatCurrency(this._currency),
            stat: phrasePlaces.reduce(function(stat, field) {
                if (field === 'cbroker') {
                    stat[field] = model.get(field);
                } else {
                    var auctionValue = u.auction.getDataByPlace(auctionData, field);
                    stat[field] = auctionValue ?
                        u.numberFormatter.format(auctionValue.bid_price / 1e6) :
                        model.get(field, 'format');
                }
                return stat;
            }, {})
        });
    }

}, {

    live: function() {
        this.liveInitOnBlockInsideEvent('click', 'link', function(e) { this.togglePopup(e.block); });
    },

    /**
     * Статическое хранилище промисов со статистикой
     * @type {Object}
     */
    _statsPromises: {},

    /**
     * Вытягивает статистику по фразам для баннера
     * @param {String} bid – идентификатор баннера
     * @param {Objects} campModelParams
     * @returns $.Deferred
     * @private
     */
    _fetchStatData: function(bid, campModelParams) {
        var stats = this._statsPromises,
            deferred = stats[bid],
            campModel = BEM.MODEL.getOne(campModelParams);

        if (deferred) return deferred;

        deferred = $.Deferred();

        BEM
            .create('i-request_type_ajax', {
                url: u.getUrl('ajaxGetPrices', {
                    ulogin: u.consts('ulogin'),
                    bid: bid,
                    cid: campModel.get('cid')
                }),
                dataType: 'json',
                cache: false,
                callbackCtx: this,
                onError: function() { deferred.reject(); }
            })
            .get({}, function(response) {
                var error;

                if (!response || response.error || !response.result) {
                    response && response.error && (error = new Error(response.error));

                    deferred.reject(error);

                    return;
                }

                // ответ описывает сущности немного не в явном ключе, что странно,
                // поэтому перекладываю данные по кампании тут
                response.campaign = response.banner;
                response.campaign.mediaType = campModel.get('mediaType');
                delete response.banner;

                // проходимся по всем стат. данным фраз для баннера и создаём модели
                response.result.forEach(function(phraseData) {
                    var pokazometerStat,
                        noPokazStat;

                    if (phraseData.price_for_coverage) {
                        pokazometerStat = phraseData.pokazometer_data;

                        noPokazStat = (+phraseData.no_pokazometer_stat === 1 ||
                            !(pokazometerStat && pokazometerStat.shows_list && pokazometerStat.shows_list.length))

                        // если нет данных от показометра, то на тематических
                        // площадках в охвате аудитории будут прочерки
                        if (noPokazStat) {
                            delete phraseData.price_for_coverage;
                        } else {
                            // расчёт текущего охвата аудитории в зависимости от ставки
                            phraseData.context_coverage = 100 * BEM.blocks['i-autobroker']
                                .calcContextCoverage(+phraseData.price_context * 1e6, pokazometerStat) || 0;
                        }
                    }

                    phraseData.campDMName = campModelParams.name;

                    BEM.MODEL.create({
                        name: 'm-phrase-bidable',
                        id: phraseData.id
                    }, phraseData);
                });

                deferred.resolve(response);
            });

        deferred.fail(function(err) {
            BEM
                .blocks['b-confirm']
                .alert(err ? err.message : iget2('b-edit-phrase-price-inline', 'oshibka-pri-zagruzke-stavok', 'Ошибка при загрузке ставок. Попробуйте еще раз.'));

            delete stats[bid];
        });

        return stats[bid] = deferred;
    }

});
