block('b-edit-phrase-price-stat-popup')(

    elem('popup-content')(

        content()(function() {
            var ctx = this.ctx,
                campaign = ctx.campaign,
                campDMParams;

            if (!ctx.isMultiedit) {
                campDMParams = {
                    name: u.campaign.getCampaignModelName(campaign.type),
                    id: campaign.cid
                };
            }

            return [
                {
                    block: 'b-edit-phrase-price-stat-popup',
                    elem: 'body',
                    content: ctx.isMultiedit ?
                        {
                            block: 'b-edit-phrase-price-stat-popup',
                            elem: 'price-wrap',
                            content: [
                                {
                                    block: 'b-edit-phrase-price-stat-popup',
                                    elem: 'platform',
                                    content: iget2('b-edit-phrase-price-stat-popup', 'edinaya-stavka', 'Единая ставка')
                                },
                                {
                                    block: 'b-edit-phrase-price',
                                    mods: {
                                        type: 'mol',
                                        multiedit: 'yes',
                                        'real-time': 'yes',
                                        'control-type': 'search',
                                        'multi-campaign': 'yes'
                                    },
                                    mix: {
                                        block: 'b-edit-phrase-price-stat-popup',
                                        elem: 'price'
                                    },
                                    currency: ctx.currency,
                                    price: ctx.price
                                },
                                {
                                    block: 'b-edit-phrase-price-stat-popup',
                                    elem: 'currency',
                                    content: u.currencies.getName(ctx.currency)
                                }
                            ]
                        } :
                        [
                            ctx.has_price && {
                                block: 'b-edit-phrase-price-stat-popup',
                                elem: 'price-wrap',
                                content: [
                                    {
                                        block: 'b-edit-phrase-price-stat-popup',
                                        elem: 'platform',
                                        content: iget2('b-edit-phrase-price-stat-popup', 'na-poiske', 'На поиске')
                                    },
                                    {
                                        block: 'b-edit-phrase-price',
                                        mods: {
                                            type: 'mol',
                                            'real-time': 'yes',
                                            'control-type': 'search'
                                        },
                                        mix: {
                                            block: 'b-edit-phrase-price-stat-popup',
                                            elem: 'price'
                                        },
                                        campDMParams: campDMParams,
                                        currency: ctx.currency,
                                        price: ctx.price
                                    },
                                    {
                                        block: 'b-edit-phrase-price-stat-popup',
                                        elem: 'currency',
                                        content: u.currencies.getName(ctx.currency)
                                    },
                                    {
                                        block: 'b-phrases-auction-popup',
                                        mix: {
                                            block: 'b-edit-phrase-price-stat-popup',
                                            elem: 'auction'
                                        },
                                        js: {
                                            tabs: { search: true },
                                            modelParams: ctx.modelParams,
                                            currency: ctx.currency,
                                            campaign: ctx.campaign
                                        }
                                    }
                                ]
                            },
                            ctx.has_price_context && {
                                block: 'b-edit-phrase-price-stat-popup',
                                elem: 'price-wrap',
                                content: [
                                    {
                                        block: 'b-edit-phrase-price-stat-popup',
                                        elem: 'platform',
                                        content: iget2('b-edit-phrase-price-stat-popup', 'v-setyah', 'В сетях')
                                    },
                                    {
                                        block: 'b-edit-phrase-price',
                                        mods: {
                                            type: 'mol',
                                            'real-time': 'yes',
                                            'control-type': 'context'
                                        },
                                        mix: {
                                            block: 'b-edit-phrase-price-stat-popup',
                                            elem: 'price'
                                        },
                                        campDMParams: campDMParams,
                                        currency: ctx.currency,
                                        price: ctx.price_context
                                    },
                                    {
                                        block: 'b-edit-phrase-price-stat-popup',
                                        elem: 'currency',
                                        content: u.currencies.getName(ctx.currency)
                                    },
                                    {
                                        block: 'b-phrases-auction-popup',
                                        mix: {
                                            block: 'b-edit-phrase-price-stat-popup',
                                            elem: 'auction'
                                        },
                                        js: {
                                            tabs: { context: true },
                                            modelParams: ctx.modelParams,
                                            currency: ctx.currency,
                                            campaign: ctx.campaign
                                        }
                                    }
                                ]
                            }
                        ]
                },
                {
                    block: 'b-edit-phrase-price-stat-popup',
                    elem: 'footer',
                    content: [
                        {
                            block: 'button',
                            mods: { theme: 'action', disabled: 'yes' },
                            mix: { block: 'b-edit-phrase-price-stat-popup', elem: 'save' },
                            content: iget2('b-edit-phrase-price-stat-popup', 'primenit', 'Применить')
                        },
                        {
                            block: 'button',
                            mix: { block: 'b-edit-phrase-price-stat-popup', elem: 'cancel' },
                            content: iget2('b-edit-phrase-price-stat-popup', 'otmenit', 'Отменить')
                        }
                    ]
                }
            ];
        })

    )

);
