BEM.DOM.decl({ name: 'b-edit-phrase-price-stat-popup', modName: 'multiedit', modVal: 'yes' }, {

    /**
     * Создает модель для единой ставки
     * @param {Array} models
     * @returns {BEM}
     */
    initModels: function(models) {
        this.models = models;

        return this;
    },

    /**
     * Обработчик клика по кнопке, открывающей попап
     * @param {jQuery.Event} e
     * @private
     */
    _onSwitcherClick: function(e) {
        this.model && this.model.destruct();
        this.model = BEM.MODEL.create({
            name: 'm-stat-phrase-bidable',
            id: 'common-price'
        }, {
            currency: this.params.currency,
            has_price: true,
            has_price_context: false
        });

        return this.__base.apply(this, arguments);
    },

    /**
     * Задает модель блоку b-edit-phrase-price
     * @param {jQuery} content
     * @returns {BEM}
     * @private
     */
    _initEditPriceBlock: function(content) {
        this.findBlockInside(content, 'b-edit-phrase-price')
            .initModels([this.model]);

        return this;
    },

    /**
     * Применяет ставки ко все переданным моделям, закрывает попап
     * @private
     */
    _save: function() {
        var price = this.model.get('price');

        this.models.forEach(function(model) {
            model.get('has_price') && model.set('price', price);
            model.get('has_price_context') && model.set('price_context', price);
            model.fix();
        });

        this.model.rollback();
        this.__self._getPopup().hide();
    },

    /**
     * Уничтожает модель единой ставки
     * @returns {BEM.DOM}
     */
    destruct: function() {
        if (this.model) {
            this.model.destruct();
        }

        return this.__base.apply(this, arguments);
    }

});
