BEM.DOM.decl('b-edit-phrase-price-stat-popup', {

    onSetMod: {

        disabled: {

            yes: function() {
                this.getSwitcher()
                    .setMod('disabled', 'yes');
            },

            '': function() {
                this.getSwitcher()
                    .delMod('disabled');
            }

        }

    },

    /**
     * Возвращает кнопку открывающую попап
     * @returns {BEM}
     */
    getSwitcher: function() {
        return this._switcherButton || (this._switcherButton = this.findBlockInside('switcher', 'button'));
    },

    /**
     * Подписывается на события модели
     * @param {BEM.MODEL} model
     * @returns {BEM}
     */
    initModels: function(model) {
        this.model = model;
        this.model
            .on('price price_context', 'change', function() {
                this.__self._getPopup().isShown() || this.validate();
            }, this)
            .on('fix', function() {
                this.updateButtonText(this.model.get('price'), this.model.get('price_context'));
                this.validate();
            }, this);

        return this;
    },

    /**
     * Проверяет наличие ошибок в ставках
     */
    validate: function() {
        var isValid = this.model.validate('price').valid && this.model.validate('price_context').valid,
            isHighPrice = this._isHighPrice(this.model.get('price')) ||
                this._isHighPrice(this.model.get('price_context'));

        if (!isValid) {
            this.getSwitcher().setMod('highlight-border', 'red');
        } else if (isHighPrice) {
            this.getSwitcher().setMod('highlight-border', 'pink');
        } else {
            this.getSwitcher().delMod('highlight-border');
        }
    },

    /**
     * Проверяет выставлена ли высокая цена
     * @param {Number} price - ставка
     * @returns {boolean}
     * @private
     */
    _isHighPrice: function(price) {
        return price > u.currencies.getConst(this.params.currency, 'BIG_RATE');
    },

    /**
     * Обработчик клика по кнопке
     * @param {jQuery.Event} e
     * @param {Object} data
     * @private
     */
    _onButtonClick: function(e, data) {
        this.elem('switcher').is(e.block.domElem) && this._onSwitcherClick(e, data);
    },

    /**
     * Обработчик клика по кнопке, открывающей попап
     * @param {jQuery.Event} e
     * @private
     */
    _onSwitcherClick: function(e) {
        if (this.__self._getPopup().isShown()) {
            this._cancel();
            return;
        }

        var params = this.params,
            model = this.model,
            popup = this.__self._getPopup(),
            content = $(BEMHTML.apply({
                block: 'b-edit-phrase-price-stat-popup',
                elem: 'popup-content',
                currency: params.currency,
                campaign: params.campaign,
                modelParams: {
                    name: 'm-stat-phrase-bidable',
                    id: model.get('modelId'),
                    path: model.path()
                },
                isMultiedit: this.hasMod('multiedit', 'yes'),
                price: model.get('price'),
                has_price: model.get('has_price'),
                price_context: model.get('price_context'),
                has_price_context: model.get('has_price_context')
            }));

        this._content = content;
        this._subMan = BEM.create('i-subscription-manager');
        this._subMan
            .on(popup, 'show', this._onPopupShow, this)
            .on(popup, 'hide', this._onPopupHide, this);

        popup.setContent(content);
        popup.toggle(e.block.domElem);
    },

    /**
     * Подписывается на события кнопок внутри открывшегося попапа и изменения ставок в модели
     * @private
     */
    _onPopupShow: function() {
        this.model.fix();
        this._saveButton = this.findBlockInside(this.findElem(this._content, 'save'), 'button');
        this._cancelButton = this.findBlockInside(this.findElem(this._content, 'cancel'), 'button');

        this._subMan
            .on(this._saveButton, 'click', this._save, this)
            .on(this._cancelButton, 'click', this._cancel, this);

        this._subMan.wrap(this.model)
            .on('price price_context', 'change', this._onModelChange, this);

        this._initEditPriceBlock(this._content);

        this.params.autofocus &&
            this.__self._getPopup()
                .findBlockInside('input')
                .setMod('focused', 'yes');

        this.trigger('show');
    },

    /**
     * Задает модель блоку b-edit-phrase-price и вызывает проверку на наличие ошибок
     * @param {jQuery} content
     * @returns {BEM}
     * @private
     */
    _initEditPriceBlock: function(content) {
        this.findBlocksInside(content, 'b-edit-phrase-price')
            .forEach(function(block) {
                block.initModels([this.model])
                    .validate();
            }, this);

        return this;
    },

    /**
     *  Дизейблит/раздизейбливает кнопку сохранить
     * @private
     */
    _onModelChange: function() {
        var isValid = this.model.validate('price').valid && this.model.validate('price_context').valid;

        this._saveButton.toggleMod('disabled', 'yes', !isValid);
    },

    /**
     * Сохраняет ставки, закрывает попап
     * @private
     */
    _save: function() {
        this.model.fix();
        this.__self._getPopup().hide();
    },

    /**
     * Меняет текст у кнопки открывающий попап
     * @param {Number} price - ставка на поиске
     * @param {Number} priceContext -  ставка в сетях
     */
    updateButtonText: function(price, priceContext) {
        var buttonText;

        price = u.formatPrice(price, '');
        priceContext = u.formatPrice(priceContext, '');

        buttonText = [price, priceContext].join(' / ');
        buttonText.length > 17 && (buttonText = [price, '...'].join(' / ')); // DIRECT-61951

        this.getSwitcher()
            .elem('text')
            .text(buttonText);
    },

    /**
     * Закрывает попап, откатывает модель
     * @private
     */
    _cancel: function() {
        this.__self._getPopup().hide();
    },

    /**
     * Отписывается от событий
     * @private
     */
    _onPopupHide: function() {
        this.model.rollback();

        this._subMan.dispose();
        this._subMan.destruct();

        this.trigger('hide');
    },

    destruct: function() {
        // TODO разобраться с animate: 'yes'
        this.__self._destructPopup();

        return this.__base.apply(this, arguments);
    }

}, {

    /**
     * Строит попап, возвращает его инстанс
     * @returns {BEM}
     * @private
     */
    _getPopup: function() {
        if (this._popup) return this._popup;

        var popup = $(BEMHTML.apply({
            block: 'popup',
            // TODO разобраться с animate: 'yes'
            mods: { autoclosable: 'yes', animate: 'no' },
            mix: {
                block: 'b-edit-phrase-price-stat-popup',
                elem: 'popup'
            },
            content: [
                { elem: 'tail' },
                { elem: 'content' }
            ]
        }));

        return this._popup = BEM.DOM.append(BEM.DOM.scope, popup).bem('popup');
    },

    _destructPopup: function() {
        if (this._popup) {
            this._popup.destruct();
        }

        this._popup = null;
    },

    live: function() {

        this.liveInitOnBlockInsideEvent('click', 'button', function(e, data) {
            this._onButtonClick(e, data);
        });

    }

});
