BEM.DOM.decl({ name: 'b-edit-phrase-price', modName: 'auto-validation', modVal: 'yes' }, {

    /**
     * Привязывает обработчики к событиям на модели
     * @returns {BEM}
     * @override
     */
    _bindModelsEvents: function() {
        var fieldName = this.getFieldName();

        this._applyToModel(function(model) {

            model.hasField(fieldName) && model.on(fieldName, 'change', this._onModelChanged, this);

            model.on('validated', function(e, data) {
                !data.field && this._updatePhrasePriceStyles();
            }, this);
        });

        return this;
    },

    /**
     * Показывает предупреждающий хинт, если это требуется
     * @private
     * @override
     */
    _showHint: function() {
        if (this.getMod('disabled') === 'yes') return;
        if (!this.model) return;

        var errors = this._getErrorsTexts();

        if (!errors.length && this._isHighPrice()) {
            errors = [
                iget2('b-edit-phrase-price', 'high-bid-warning', 'Обратите внимание, установлена высокая ставка')
            ];
        }

        errors.length && this._getHintPopup()
            .setContent(errors)
            .show(this.domElem);
    },

    /**
     * Устанавливает css-стили для контрола
     * @override
     */
    _updatePhrasePriceStyles: function() {
        if (!this._isControlAlive()) return;

        var control = this._getControl();

        control
            .delMod('error')
            .delMod('warning');

        if (this._getErrorsCount()) {
            control.setMod('error', 'yes');
        } else if (this._isHighPrice()) {
            control.setMod('warning', 'yes');
        }
    }

});
