BEM.DOM.decl({ name: 'b-edit-phrase-price', modName: 'control-type', modVal: 'cpc' }, {

    /**
     * Проверяет "полезность" модели
     * Для переопределения при случаях, когда модель не нужно учитывать при мультиредактировании
     * @param {BEM.MODEL} model
     * @returns {Boolean}
     * @private
     * @override
     */
    _isUsefulModel: function(model) {
        return !model.get('use_default_price');
    },

    /**
     * Привязывает обработчики к событиям на модели
     * @returns {BEM}
     * @override
     */
    _bindModelsEvents: function() {
        this._applyToModel(function(model) {
            // при выборе ставки по умолчанию вызывать обработчик изменения модели
            // для обновления поля ввода ставки при мультиредактировании
            model.hasField('use_default_price') && model.on('use_default_price', 'change', this._onModelChanged, this);
        });

        return this.__base.apply(this, arguments);
    }

});
