/**
 * @params {Object} campDMParams - данные для создания дата-модели кампании
 */
block('b-edit-phrase-price')(

    def()(function() {
        return applyNext({
            'ctx.hasError': this.ctx.hasError || this.mods.error == 'yes',
            'ctx.hasWarning': this.ctx.hasWarning || this.mods.warning == 'yes'
        });
    }),

    js()(function() {
        return {
            campDMParams: this.ctx.campDMParams,
            value: this.ctx.value,
            currency: this.ctx.currency || (this.ctx.banner && this.ctx.banner.currency),
            popupDirections: this.ctx.popupDirections
        };
    }),

    content()(function() {
        return {
            block: 'input',
            mix: [
                {
                    block: 'b-edit-phrase-price',
                    elem: 'price',
                    elemMods: {
                        mode: /^(RUB|UAH|KZT)$/.test(this.ctx.currency || this.ctx.banner && this.ctx.banner.currency) ?
                            'large' :
                            'normal'
                    }
                },
                this.mods.disabled && {
                    block: 'b-hintable',
                    js: {
                        hint: this.ctx.disabledHintText
                    }
                }
            ],
            mods: {
                clear: 'no',
                change: 'keypress',
                highlight: this.mods.highlight,
                disabled: this.mods.disabled,
                warning: this.mods.multiedit != 'yes' &&
                    this.ctx.hasWarning && !this.ctx.hasError ? 'yes' : '',
                error: this.mods.multiedit != 'yes' &&
                    this.ctx.hasError ? 'yes' : ''
            },
            value: this.ctx.price,
            content: {
                elem: 'control',
                mix: {
                    block: 'b-edit-phrase-price',
                    elem: 'control',
                    elemMods: {
                        'align-right': (this.mods || {})['align-right']
                    }
                },
                attrs: {
                    value: this.ctx.price
                }
            }
        };
    })
);
