BEM.DOM.decl('b-edit-phrase-price', {
    onSetMod: {
        js: function() {
            var _this = this,
                campDMName = (this.params.campDMParams || {}).name,
                model = BEM.MODEL.create('m-bidable', { campDMName: campDMName });

            // осторожно, это поле не всегда корректно, так как в некоторых местах
            // (campDMName не передается
            // (campDMName не передается
            // и модели инициализируеются через метод initModels и могут координально отличаться от m-bidable
            // и кампания там может быть совсем другая)
            this.campaignModel = BEM.MODEL.getOne(model.get('campDMName'));
            this.initModels([model]);

            // для DIRECT-31557 вначале инициализируем блок, после вешаем ему модификатор

            this._groupPhrase = this.findBlockOutside('b-group-phrase');
            if (this._groupPhrase) {
                this._groupPhrase.setMod('hovered', 'yes');
            }

            if (/^(price|price_context|price_cpa|price_cpc|general_limit_price)$/.test(this.getFieldName())) {
                this._getControl()
                    .bindTo('control', 'keyup', function(e) {
                        //press enter
                        e.which == 13 && this.delMod('focused');
                    })
                    .bindTo('control', 'blur', function() {
                        _this._onControlAction();
                    })
                    .bindTo('control', 'mouseenter', function(e) {
                        _this._showHint();
                    })
                    .bindTo('control', 'mouseleave', function(e) {
                        _this._hideHint();
                    });

                this.hasMod('real-time', 'yes') && this._getControl().on('change', this._onControlAction, this);
            }
        },
        disabled: function(modName, modVal) {
            this._getControl().setMod(modName, modVal);
        }
    },

    /**
     * Возвращает имя поля модели, с которым связан контрол в данном блоке
     * @returns {String}
     */
    getFieldName: function() {
        return this.__self.getFieldName(this.getMod('control-type'));
    },

    /**
     * Возвращает значение контрола
     * @returns {*}
     */
    getControlValue: function() {
        return u.numberFormatter.clear(this._getControl().val());
    },

    /**
     * Устанавливает значение контрола
     * @param {*} value
     * @returns {BEM}
     */
    setControlValue: function(value) {
        this._getControl()
            .delMod('warning')
            .delMod('error')
            .val(value);

        return this;
    },

    setModelValue: function(value) {
        var fieldName = this.getFieldName();

        this._applyToModel(function(model) {
            model.set(fieldName, value, { source: this });
        });
    },

    /**
     * Инициализирует модели для данного блока
     * @param {BEM.MODEL[]} models
     * @returns {BEM}
     */
    initModels: function(models) {
        this.models = models;

        this.model = models[0];

        return this._bindModelsEvents();
    },

    /**
     * Валидация без триггера событий и установки полей
     */
    lazyValidate: function() {
        this.model.validate();
        this._updatePhrasePriceStyles(this.getControlValue());
    },

    /**
     * Возвращает данные для валидации цены
     * @private
     */
    _getPriceLimits: function() {
        var campDmParams = this.params.campDMParams,
            campaignModelName,
            campModel = this.campaignModel,
            mediaType = campModel && campModel.get('mediaType');

        // Для медийного продукта на главной мы не кэшируем лимиты
        if (!this._priceLimits || mediaType === 'cpm_yndx_frontpage') {
            var cid = (campModel && campModel.get('cid')) || this.model.get('cid');

            // почему так странно определяется имя модели?
            // потому что блоку в половине мест передается в контекст campDmParams,
            // а в некоторых нет и модели инициализируются через initModels и это значит,
            // что в этих моделях может быть что угодно и может не быть поля campDMName
            if (campDmParams && campDmParams.name) {
                campaignModelName = campDmParams.name;
            } else {
                campaignModelName = this.model.get('campDMName');
            }

            this._priceLimits = u.bids.getLimits(
                campaignModelName,
                this._getCurrency(),
                cid,
                this.model.get('adgroup_id')
            );
        }

        return this._priceLimits;
    },

    /**
     * Возвращает валюту кампании
     * @returns {String}
     * @private
     */
    _getCurrency: function() {
        return this.campaignModel && this.campaignModel.get('currency') ?
            this.campaignModel.get('currency') :
            this.params.currency;
    },

    /**
     * Возвращает текущее значение для контрола по данным модели
     * @param {String} [mode] режим вывода результата (по умолчанию - выдаёт результат get, принимает также значения 'view' и 'raw')
     * @returns {*}
     */
    _getValue: function(mode) {
        var result,
            isResultSet,
            fieldName = this.getFieldName();

        this._applyToModel(function(model) {
            if (!this._isUsefulModel(model)) return;

            var value = model.get(fieldName, mode);

            if (!isResultSet) {
                result = value;

                isResultSet = true;
            } else {
                value != result && (result = '');
            }
        }, this);

        return result;
    },

    /**
     * Проверяет "полезность" модели
     * Для переопределения при случаях, когда модель не нужно учитывать при мультиредактировании
     * @param {BEM.MODEL} model
     * @returns {Boolean}
     * @private
     */
    _isUsefulModel: function(model) {
        return true;
    },

    /**
     * Возвращает текст ошибки
     * @returns {String|Null}
     * @private
     */
    _getHintContent: function() {
        if (this.getMod('disabled') === 'yes') return;

        var isGroupValue = this.hasMod('multiedit', 'yes'),
            price = isGroupValue ?
                this.getControlValue() :
                this.model && this.model.get(this.getFieldName()),
            content = null,
            priceLimits = this._getPriceLimits();

        if (price !== '') {
            if (price < priceLimits.minPrice.value) {
                content = priceLimits.minPrice.errorText;
            } else if (price > priceLimits.maxPrice.value) {
                content = priceLimits.maxPrice.errorText;
            } else if (this._isHighPrice(price)) {
                content = priceLimits.bigRate.errorText;
            }
        }

        return content;
    },

    /**
     * Показывает предупреждающий хинт, если это требуется
     * @private
     */
    _showHint: function() {
        var content = this._getHintContent();

        content && this._getHintPopup()
            .setContent(content)
            .show(this.domElem);
    },

    /**
     * Прячет хинт
     * @private
     */
    _hideHint: function() {
        this._getHintPopup().hide();
    },

    /**
     * Возвращает блок попап для показа подсказки об ошибке
     * @returns {BEM}
     */
    _getHintPopup: function() {
        return this.popup || (this.popup = BEM.blocks['b-shared-popup'].getInstance(
            {},
            { directions: this.params.popupDirections || 'left' },
            { content: { block: 'b-edit-phrase-price', elem: 'popup-content' } })
        );
    },

    /**
     * Проверяет, активен ли данный контрол
     * @returns {Boolean}
     */
    _isControlActive: function() {
        var control = this._getControl();

        return !!(control && control.hasMod('focused', 'yes'));
    },

    /**
     * Проверяет, жив ли данный контрол
     * @returns {Boolean}
     */
    _isControlAlive: function() {
        var control = this._getControl();

        return !!(control && control.domElem);
    },

    /**
     * Возвращает контрол
     * @returns {BEM}
     */
    _getControl: function() {
        return this.control || (this.control = this.findBlockOn('price', 'input'));
    },

    /**
     * Привязывает обработчики к событиям на модели
     * @returns {BEM}
     */
    _bindModelsEvents: function() {
        var fieldName = this.getFieldName();

        this._applyToModel(function(model) {
            model.hasField(fieldName) && model.on(fieldName, 'change', this._onModelChanged, this);
        });

        return this;
    },

    /**
     * Пользователь изменил контрол для ввода цены
     */
    _onControlAction: function() {
        var value = this.getControlValue(),
            control = this._getControl(),
            isMulti = this.hasMod('multiedit', 'yes'),
            campModel = this.campaignModel,
            visitParams = {};

        control.delMod('warning').delMod('error');

        if (isMulti && !this.hasMod('real-time', 'yes')) {
            if (!value) return;

            if (!this._prevalidateValue(value)) {
                control.setMod('error', 'yes');
                return;
            }
        }

        this.setModelValue(value);

        // DIRECT-79202 логируем изменение ставок для трафаретных торгов
        if (campModel && campModel.get('mediaType') === 'text' && campModel.get('platform') === 'search') {
            visitParams[isMulti ? 'change-price-for-group' : 'change-price-for-single'] = true;

            BEM.blocks['b-metrika2'].params({
                params: visitParams
            });
        }

        // контролы должны обновить свое состояние активности, чтобы правильно сработала проверка this._isControlActive()
        this.afterCurrentEvent(function() {
            this._onModelChanged();
        }, this);
    },

    validate: function() {
        this._onModelChanged();
    },

    /**
     * Обработчик изменения полей модели
     * @param {jQuery.Event} [e]
     */
    _onModelChanged: function(e) {
        var isMulti = this.hasMod('multiedit', 'yes');

        if (this._isControlAlive() && !this._isControlActive()) {
            isNaN(this._getValue()) ?
                this.setControlValue(isMulti ? '' : '0.00') :
                this.setControlValue(this._getValue('format'));
        }

        this._applyToModel(function(model) {
            model.validate(this.getFieldName());
        }, this);

        this.model && this._updatePhrasePriceStyles();

        this.trigger('change', { value: this.getControlValue() });
    },

    /**
     * Применяет функцию callback ко всем моделям блока
     * @param {Function} callback
     * @param {Object} [ctx]
     * @protected
     */
    _applyToModel: function(callback, ctx) {
        ctx = ctx || this;

        if (this.hasMod('multiedit', 'yes')) {
            this.models && this.models.forEach(function(model) {
                callback.call(ctx, model);
            });
        } else {
            callback.call(ctx, this.model);
        }
    },

    /**
     * Возвращает модель группы фраз
     * @returns {BEM.MODEL}
     * @private
     */
    _getPhrasesListModel: function() {
        return this.listModel ||
            (this.listModel = BEM.MODEL.getOrCreate({ name: 'm-phrases-list', id: this.model.get('adgroup_id') }));
    },

    _prevalidateValue: function(value) {
        var priceLimits = this._getPriceLimits(),
            minValue = priceLimits.minPrice.value,
            maxValue = priceLimits.maxPrice.value;

        return this.hasMod('multiedit', 'yes') && this.hasMod('real-time', 'yes') ?
            !(value < minValue || value > maxValue) :
            !(isNaN(value) || value < minValue || value > maxValue);
    },

    /**
     * Устанавливает css-стили для контрола
     */
    _updatePhrasePriceStyles: function(price) {
        var phrasesListModel,
            control,
            value;

        if (!this._isControlAlive()) return;

        value = price === undefined ? this.model.get(this.getFieldName()) : +price;
        phrasesListModel = this._getPhrasesListModel();
        control = this._getControl();

        if (control.hasMod('warning')) {
            phrasesListModel.set('priceWarningsCount', phrasesListModel.get('priceWarningsCount') - 1);
        }

        control
            .delMod('error')
            .delMod('warning');

        if (value === '' || !this._prevalidateValue(value)) {
            control.setMod('error', 'yes');
        } else if (this._isHighPrice(value)) {
            control.setMod('warning', 'yes');
        }
    },

    /**
     * Проверяет выставлена ли высокая цена
     * @returns {Boolean}
     * @protected
     */
    _isHighPrice: function(price) {
        var value = price === undefined ? this.model.get(this.getFieldName()) : price,
            priceLimits = this._getPriceLimits();

        if (!priceLimits.bigRate) {

            return false;
        }

        return value > priceLimits.bigRate.value;
    },

    /**
     * Валидирует и возвращает ошибки валидации
     * @returns {Object[]}
     * @private
     */
    _getErrors: function() {
        return this.model.validate(this.getFieldName()).errors || [];
    },

    /**
     * Возвращает количество ошибок при валидации
     * @returns {Number}
     * @protected
     */
    _getErrorsCount: function() {
        return this._getErrors().length;
    },

    /**
     * Возвращает список ошибок в виде текста
     * @returns {String[]}
     * @protected
     */
    _getErrorsTexts: function() {
        return this._getErrors().map(function(error) {
            return error.text;
        });
    }

}, {

    /**
     * Возвращает имя поля модели, с которым связан контрол в данном блоке
     * @param {String} [controlType]
     * @returns {String}
     */
    getFieldName: function(controlType) {
        return ({
            cpa: 'price_cpa',
            cpc: 'price_cpc',
            context: 'price_context',
            search: 'price',
            'general-limit': 'general_limit_price'
        })[controlType]
    },

    live: function() {
        this
            .liveInitOnEvent('mouseover', function() {
                if (/^(price|price_context|price_cpa|price_cpc|general_limit_price)$/.test(this.getFieldName())) {
                    this._showHint();
                }
            })
            .liveInitOnBlockInsideEvent('focus', 'input')
            .liveInitOnBlockInsideEvent('click', 'checkbox', function() { this._onControlAction() })
            .liveInitOnBlockInsideEvent('click', 'link', function() { this._onControlAction() });
    }

});
