block('b-edit-regions-popup')(

    js()(function() {
        return {
            selectedRegions: this.ctx.selectedRegions,
            hasBidsCorrections: this.ctx.hasBidsCorrections
        }
    }),

    content()(function() {

        return [
            {
                elem: 'header',
                mix: {
                    block: 'b-modal-popup-decorator',
                    elem: 'header',
                    elemMods: {
                        separated: 'no'
                    }
                },
                content: [
                    {
                        block: 'b-modal-popup-decorator',
                        elem: 'header-text',
                        content: iget2('b-edit-regions-popup', 'regiony-pokaza', 'Регионы показа')
                    },
                    {
                        block: 'b-modal-popup-decorator',
                        elem: 'header-note',
                        content: iget2(
                            'b-edit-regions-popup',
                            'vyberite-regiony-v-kotoryh',
                            'Выберите регионы, в которых вы бы хотели показывать рекламу. Обратите внимание, выбрав регион, вы выбираете все входящие в него населенные пункты.'
                        )
                    }
                ]
            },
            {
                elem: 'body',
                mix: {
                    block: 'b-modal-popup-decorator',
                    elem: 'body'
                },
                content: [
                    {
                        block: 'b-regions',
                        mods: {
                            'has-independent-filter-warning': this.ctx.hasIndependentRegionsWarning ? 'yes' : '',
                            'bids-corrections': this.ctx.hasBidsCorrections ? 'yes' : ''
                        },
                        mix: {
                            block: 'b-edit-regions-popup',
                            elem: 'regions'
                        },
                        regions: this.ctx.regions,
                        disableRegions: this.ctx.disableRegions,
                        independentRegions: this.ctx.independentRegions,
                        quickSelectRegions: this.ctx.quickSelectRegions,
                        quickSelectUserRegion: this.ctx.quickSelectUserRegion,
                        isCommon: this.ctx.isCommon,
                        isBidsCorrectionsModeOn: this.ctx.isBidsCorrectionsModeOn,
                        disableEditBids: this.ctx.disableEditBids,
                        disableEditBidsHint: this.ctx.disableEditBidsHint,
                        hintForDifferentRegions: this.ctx.hintForDifferentRegions
                    },
                    {
                        block: 'b-edit-regions-popup',
                        elem: 'errors',
                        elemMods: {
                            visible: 'no'
                        }
                    }
                ]
            },
            {
                elem: 'footer',
                mix: { block: 'b-modal-popup-decorator', elem: 'footer' },
                content: [
                    {
                        block: 'button',
                        mods: { theme: 'action', size: 's' },
                        mix: [
                            { block: 'b-modal-popup-decorator', elem: 'footer-button' },
                            { block: 'b-edit-regions-popup', elem: 'save' }
                        ],
                        content: iget2('b-edit-regions-popup', 'sohranit', 'Сохранить')
                    },
                    {
                        block: 'button',
                        mods: { size: 's' },
                        mix: [
                            { block: 'b-modal-popup-decorator', elem: 'footer-button' },
                            { block: 'b-edit-regions-popup', elem: 'cancel' }
                        ],
                        content: iget2('b-edit-regions-popup', 'otmena', 'Отмена')
                    },
                    {
                        block: 'spin2',
                        mix: { block: 'b-edit-regions-popup', elem: 'progress-spin' },
                        mods: { size: 'xxs' }
                    }
                ]
            }
        ];
    }),

    elem('errors').content()(function() {
        return [
            { block: 'icon', mods: { 'size-12': ['alert'] } },
            '&nbsp;',
            this.ctx.text || ''
        ]
    })
);
