/**
 * Условия подбора аудитории
 *
 * @param {Boolean} [ctx.singleChoice] флаг, отвечающий за возможность выбора нескольких условий ретаргетинга
 * @param {Object} [ctx.conditions] список возможных условий ретаргетинга
 * @param {Object} [ctx.selectedConditions] список активных условий ретаргетинга
 * @param {String} ctx.headerHelpLink ссылка на help в заголовке
 * @param {String} ctx.listItemHintLink ссылка на help в подсказке для условия
 *
 */
block('b-edit-retargeting')(

    js()(function() {
        return {
            conditions: this.ctx.conditions,
            selectedConditions: this.ctx.selectedConditions
        };
    }),

    content()(function() {
        var selectedConditions = this.ctx.selectedConditions || [],
            selectedConditionIds = selectedConditions.reduce(function(result, condition) {
                result[condition.ret_cond_id] = true;

                return result;
            }, {});

        return [
            {
                elem: 'header',
                mix: {
                    block: 'b-modal-popup-decorator',
                    elem: 'header'
                },
                content: [
                    {
                        block: 'b-modal-popup-decorator',
                        elem: 'header-text',
                        content: [
                            iget2('b-edit-retargeting', 'usloviya-podbora-auditorii', 'Условия подбора аудитории'),
                            {
                                block: 'b-help-link',
                                mix: {
                                    block: 'b-modal-popup-decorator',
                                    elem: 'help-link'
                                },
                                mods: { type: 'modal' },
                                stretched: true,
                                url: u.getHelpUrl('retargeting-impressions')
                            }
                        ]
                    },
                    {
                        block: 'b-modal-popup-decorator',
                        elem: 'header-note',
                        content: iget2('b-edit-retargeting', 'udalit-mozhno-tolko-te', 'Удалить можно только те условия, которые не используются в кампаниях.')
                    }
                ]
            },
            {
                elem: 'body',
                content: [
                    {
                        block: 'b-retargeting-conditions-list',
                        mods: {
                            'popup-decorated': 'yes'
                        },
                        singleChoice: this.ctx.singleChoice,
                        conditions: this.ctx.conditions.map(function(item) {
                            item.isSelected = !!selectedConditionIds[item.ret_cond_id];

                            return item;
                        })
                    }
                ]
            },
            {
                elem: 'footer',
                mix: { block: 'b-modal-popup-decorator', elem: 'footer' },
                content: [
                    {
                        block: 'button',
                        mods: { theme: 'action', size: 's', disabled: 'yes' },
                        mix: [
                            { block: 'b-modal-popup-decorator', elem: 'footer-button' },
                            { block: 'b-edit-retargeting', elem: 'save' }
                        ],
                        content: iget2('b-edit-retargeting', 'sohranit', 'Сохранить')
                    },
                    {
                        block: 'button',
                        mods: { size: 's' },
                        mix: [
                            { block: 'b-modal-popup-decorator', elem: 'footer-button' },
                            { block: 'b-edit-retargeting', elem: 'cancel' }
                        ],
                        content: iget2('b-edit-retargeting', 'otmena', 'Отмена')
                    },
                    !this.ctx.singleChoice && {
                        elem: 'selected-items',
                        content: selectedConditions.length ? [
                            iget2('b-edit-retargeting', 'vybrano', 'Выбрано'),
                            ' ',
                            u.pluralize([iget2('b-edit-retargeting', 'uslovie', 'условие'), iget2('b-edit-retargeting', 'usloviya', 'условия'), iget2('b-edit-retargeting', 'usloviy', 'условий')], selectedConditions.length)
                        ] :
                            ''
                    }
                ]
            }
        ];
    })
);
