/**
 * Событие инициализации блока с целями
 * @event b-edit-retargeting#edit:completed
 * @type {Object}
 * @property {Array} conditions массив выбранных условий ретаргетинга
 *
 * @fires b-edit-retargeting#edit:completed событие сохранения выбора условий ретаргетинга
 * @fires b-edit-retargeting#added-condition добавлено новое условие
 * @fires b-edit-retargeting#updated-condition изменены данные условия
 */
BEM.DOM.decl({ block: 'b-edit-retargeting', implements: 'i-modal-popup-inner-block-interface' }, {
    onSetMod: {
        js: function() {
            this._conditions = this.params.conditions;
            this._selectedConditions = this.params.selectedConditions || [];
            this._conditionsListBlock = this.findBlockInside('b-retargeting-conditions-list');
            this._saveBtn = this.findBlockOn('save', 'button');
            this._cancelBtn = this.findBlockOn('cancel', 'button');

            this._initEvents();

            this._updateGeoHintVisibility(this._getSelectedConditions());
        }
    },

    /**
     * Были ли изменения
     * @returns {$.Deferred<Boolean>}
     */
    isChanged: function() {
        var deferred = $.Deferred();

        deferred.resolve(this._isChanged);

        return deferred;
    },

    /**
     * Удаляет блок, модель и подписки i-subscription-manager
     * @override
     */
    destruct: function() {
        this._subscribe.dispose();

        this.__base.apply(this, arguments);
    },

    /**
     * Флаг, были ли изменения в условиях
     * {Boolean}
     * @private
     */
    _isChanged: false,

    /**
     * Выполняет подписку на события через i-subscription-manager
     * @private
     */
    _initEvents: function() {
        this._subscribe = BEM.create('i-subscription-manager');

        this._subscribe
            .on(this._saveBtn, 'click', this._save, this)
            .on(this._cancelBtn, 'click', this._completeEdit, this)
            .on(this._conditionsListBlock, 'change', this._onChangeChooserState, this)
            .on(this._conditionsListBlock, 'added-new-condition', this._onAddNewCondition, this)
            .on(this._conditionsListBlock, 'updated-exist-condition', this._onUpdateCondition, this);
    },

    /**
     * обработчик события добавления нового условия
     * @param {*} e
     * @param {*} data данные созданного условия ретаргетинга
     * @private
     */
    _onAddNewCondition: function(e, data) {
        this.trigger('added-condition', data);
    },

    /**
     * обработчик события изменения условия
     * @param {*} e
     * @param {*} data данные условия
     * @private
     */
    _onUpdateCondition: function(e, data) {
        this._isChanged = true;
        this._saveBtn.setMod('disabled', '');
        this.trigger('updated-condition', data);

        //
        //console.log('update-condition', data);
    },

    /**
     * Завершение редактирования условий ретаргетинга
     * @fires edit:completed
     * @private
     */
    _completeEdit: function() {
        // DIRECT-59123: отмена закрывает попапы с force
        this.trigger('edit:completed', { conditions: this._selectedConditions.slice(), force: true });
    },

    /**
     * Сохраняет выбор условий ретаргетинга
     * @private
     */
    _save: function() {
        this._selectedConditions = this._getSelectedConditions();

        // присваиваем флагу false, чтобы не было сообщения о измененных данных
        this._isChanged = false;

        this._completeEdit();
    },

    /**
     * Обработчик события изменения списка выбранных условий
     * @private
     */
    _onChangeChooserState: function(e , data) {
        var selectedConditions = this._getSelectedConditions();

        this._isChanged = true;

        this._saveBtn.setMod('disabled', '');

        this._updateSelectedItemsText(selectedConditions);
        this._updateGeoHintVisibility(selectedConditions);
    },

    /**
     * Обновляет массив выбранных условий в соответсвии с чекнутыми пользователем
     * @private
     */
    _getSelectedConditions: function() {
        var selectedConditions = this._conditionsListBlock.getSelectedConditions();

        return selectedConditions.map(function(condition) {
            // не затираем поля, которые пришли к нам с сервера в данных условий ретаргетинга
            // (в частности ret_id, нужный для определения сохраненных ставок)

            var currentConditionData = u._.find(this._conditions, function(item) {
                return condition.ret_cond_id === item.ret_cond_id;
            });

            return u._.extend(currentConditionData || {}, condition);
        }, this);
    },

    /**
     * Меняет видимость подсказки о гео-сементах выбранных целей
     * @param {Array} selectedConditions список выбранных условий
     * @private
     */
    _updateGeoHintVisibility: function(selectedConditions) {
        var isVisible = false;

        if (selectedConditions.length) {
            selectedConditions.forEach(function(condition) {
                condition.hasGeoSegement && (isVisible = true);
            });
        }

        this._conditionsListBlock.setVisibleGeoHint(isVisible);
        isVisible && this.trigger('repaint');
    },

    /**
     * Обновляет текст сообщения о количестве выбранных условий
     * @param {Array} selectedConditions список выбранных условий
     * @private
     */
    _updateSelectedItemsText: function(selectedConditions) {
        var selectedItemsText = '',
            selectedItemsNumber = selectedConditions.length;

        if (!this.elem('selected-items')) {
            return;
        }

        if (selectedItemsNumber) {
            selectedItemsText = iget2('b-edit-retargeting', 'vybrano-num', 'Выбрано {num}', {
                num: u.pluralize([iget2('b-edit-retargeting', 'uslovie', 'условие'), iget2('b-edit-retargeting', 'usloviya', 'условия'), iget2('b-edit-retargeting', 'usloviy', 'условий')], selectedItemsNumber)
            });
        }

        this.elem('selected-items').text(selectedItemsText);
    }

}, {
    live: true
});
