block('b-edit-survey').elem('row-select')(

    def()(function() {
        return {
            mixes: {
                row: [
                    {
                        block: 'b-edit-survey',
                        elem: 'row',
                        elemMods: {
                            name: 'type'
                        }
                    },
                    {
                        block: 'b-edit-survey',
                        elem: 'row-select'
                    }
                ]
            },

            label: iget2('b-edit-survey', 'tip-oprosa', 'Тип опроса'),
            control: apply('control-content')
        };
    }),

    mode('control-content')(function() {
        var dataForm = this.data.FORM,
            options = {
                surveymonkey: 'SurveyMonkey',
                tns: 'TNS'
            };

        return {
            block: 'select',
            name: 'type',
            mix: [{
                block: 'b-edit-survey',
                elem: 'type'
            }],
            content: [
                {
                    block: 'button',
                    content: options[dataForm.type] || 'SurveyMonkey'
                },
                {
                    elem: 'control',
                    content: Object.keys(options).map(function(val) {
                        return {
                            elem: 'option',
                            attrs: {
                                value: val,
                                selected: (dataForm.type === val || val === 'surveymonkey') ? 'selected' : undefined
                            },
                            content: options[val]
                        };
                    }, this)
                }
            ]
        };
    })
);
