block('b-edit-survey').content()(function() {
    return [
        {
            elem: 'survey-id',
            content: '&nbsp;'
        },
        {
            block: 'b-layout-form',
            mix: [{
                block: 'b-edit-survey',
                elem: 'form'
            }],
            action: this.data.script,
            mixes: {
                label: [{
                    block: 'b-edit-survey',
                    elem: 'label'
                }],
                control: [{
                    block: 'b-edit-survey',
                    elem: 'control'
                }],
                submit: [{
                    block: 'b-edit-survey',
                    elem: 'row-submit'
                }]
            },

            rows: applyCtx([
                {
                    elem: 'row-select'
                },
                {
                    elem: 'row-input',
                    elemMods: {
                        name: 'title'
                    }
                },
                {
                    elem: 'row-input',
                    elemMods: {
                        name: 'ext-survey-id'
                    }
                },
                {
                    elem: 'row-input',
                    elemMods: {
                        name: 'ext-collector-id'
                    }
                }, // surveymonkey
                {
                    elem: 'row-input',
                    elemMods: {
                        name: 'tracking-var'
                    }
                }, // surveymonkey
                {
                    elem: 'row-input',
                    elemMods: {
                        name: 'ext-contractor-id'
                    }
                }, // tns
                {
                    elem: 'row-date',
                    elemMods: {
                        name: 'start-date'
                    }
                },
                {
                    elem: 'row-date',
                    elemMods: {
                        name: 'finish-date'
                    }
                },
                {
                    elem: 'row-input',
                    elemMods: {
                        name: 'users-list'
                    }
                }
            ]),

            hiddenInputs: [
                {
                    name: 'survey_id',
                    mix: [{
                        block: 'b-edit-survey',
                        elem: 'hidden',
                        elemMods: {
                            name: 'survey-id'
                        }
                    }],
                    value: this.data.survey_id || ''
                },
                {
                    name: 'cmd',
                    value: this.data.FORM.cmd || 'manageSurveys'
                },
                {
                    name: 'submit_form',
                    value: 1
                }
            ],

            submit: {
                block: 'button',
                mix: [{
                    block: 'b-edit-survey',
                    elem: 'submit'
                }],
                content: iget2('b-edit-survey', 'sohranit', 'Сохранить')
            }
        }
    ];
});
