BEM.DOM.decl('b-edit-survey', {

    onSetMod: {

        edit: {

            yes: function() {
                ['type', 'ext-survey-id', 'ext-collector-id', 'tracking-var', 'ext-contractor-id']
                    .forEach(function(modVal) {
                        this.setMod(this.elem('row', 'name', modVal), 'disabled', 'yes');
                        this._getControl(modVal).setMod('disabled', 'yes');
                    }, this);
            }
        }

    },

    /**
     * {BEM.DOM}
     * @private
     */
    _controls: null,

    /**
     * Возвращает контролы формы по modVal
     * @param {String} modVal
     * @returns {BEM.DOM}
     * @private
     */
    _getControl: function(modVal) {
        this._controls || (this._controls = {});

        if (this._controls[modVal]) return this._controls[modVal];

        switch (modVal) {
            case 'start-date':
            case 'finish-date':
                return (this._controls[modVal] = this.findBlockOn(this.elem('date', 'name', modVal), 'b-date-input'));

            case 'survey-id':
                return (this._controls[modVal] = this.findBlockOn(this.elem('hidden', 'name', modVal), 'b-hidden'));

            case 'type':
                return (this._controls[modVal] = this.findBlockOn('type', 'select'));

            default:
                return (this._controls[modVal] = this.findBlockOn(this.elem('input', 'name', modVal), 'input'));
        }
    },

    /**
     * Заполняет значениями поля формы
     * @param {Object} data
     */
    setFields: function(data) {
        var _this = this;

        Object.keys(data).forEach(function(key) {
            var field = _this._getControl(key);

            switch (key) {
                case 'users-list':
                    field.val('') && field.elem('control').attr(
                        'placeholder',
                        data[key] ? data[key].join('\n') : iget2('b-edit-survey', 'poka-pusto', 'пока пусто')
                    );
                    break;

                case 'survey-id':
                    _this.elem('survey-id').html('№&nbsp;' + data[key]);
                    field && field.val(data[key]);
                    break;

                default:
                    field && field.val(data[key]);
                    break;
            }

        });

        // Для уже существующих опросов, до появления «Типа опроса»
        data.type || this._getControl('type').val('surveymonkey');
    },

    /**
     * Обработчик события change на селекте «Тип опроса»
     * @param {Event} e
     * @private
     */
    _onChangeSelect: function(e) {
        this.setMod('for', e.block.val());
    },

    /**
     * Обработчик события click на кнопке «Сохранить»
     * удаляет лишние элементы в зависимости от типа опроса
     * сабмитит форму
     * @private
     */
    _onClickSubmit: function() {
        var destructRowInput = this.hasMod('for', 'tns') ?
                ['ext-collector-id', 'tracking-var'] :
                ['ext-contractor-id'];

        destructRowInput.forEach(function(modVal) {
            BEM.DOM.destruct(this.elem('row-input', 'name', modVal));
        }, this);

        this.elem('form').submit();
    }

}, {

    live: function() {

        this
            .liveInitOnBlockInsideEvent('change', 'select', function(e) {
                this._onChangeSelect(e);
            })
            .liveBindTo('submit', 'click', function() {
                this._onClickSubmit();
            });

    }

});
