BEM.DOM.decl('b-editable-label', {

    onSetMod: {
        js: function() {

            this._input = this.blockInside('input');
            this._text = this.elem('text');
            this._button = this.blockInside('edit-button', 'button2');
        },

        edit: {
            '': function() {
                this._input.delMod('focused');
            }
        },

        error: {
            yes: function() {
                this._onLabelClick();
            },
            '': function() {
                this.hidePopup();
            }
        }
    },

    /**
     * Обработчик события click на label
     * @private
     */
    _onLabelClick: function() {
        var control = this._input.elem('control')[0],
            end = this._input.val().length,
            range = control.createTextRange && control.createTextRange();

        this.setMod('edit', 'yes');

        // focused будет ставить focus, поэтому нужно быть увереным, что control при этом виден
        this._input.setMod('focused', 'yes');

        // DIRECT-75094: устанавливает курсор в конец input'а
        if (range) {
            // IE
            range.collapse(true);
            range.moveEnd('character', end);
            range.moveStart('character', end);
            range.select();
        } else if (control.setSelectionRange) {
            control.setSelectionRange(end, end);
        }
    },

    /**
     * Обработчик события keydown
     * @param {jQuery.Event} e
     * @private
     */
    _onInputKeyDown: function(e) {
        if (e.which === BEM.blocks.keycodes.ENTER) {
            this._onInputBlur();
            e.preventDefault();
        }
    },

    /**
     * Обработчик события change
     * @private
     */
    _onInputChange: function() {
        this.delMod('error');
        this.setValue(this._input.val());
    },

    /**
     * Обработчик события blur, скрываем поле ввода только в том случае, если нет ошибок
     * @private
     */
    _onInputBlur: function() {
        if (!this.hasMod('error')) {
            this.delMod('edit');
        }
    },

    /**
     * Возвращает инстанс блока подсказки
     *
     * @returns {BEM.DOM}
     * @private
     */
    _getTipman: function() {
        return this._tipman || (this._tipman = BEM.create('tipman', {
            tipMods: { size: 's', theme: 'error', autoclosable: 'no' },
            popupDirections: 'right',
            onScrollClose: false
        }));
    },

    /**
     * Установка значения в поле
     * @param {String} val - значение
     */
    setValue: function(val) {
        this._text.text(val);
        this._input.val(val);
        this._button.domElem.attr('title', val);
        this.trigger('change', { value: val });
    },

    /**
     * Получение значения
     */
    getValue: function() {
        return this._input.val();
    },

    /**
     * Показывает ошибку
     * @param {String} text - текст ошибки
     */
    showError: function(text) {
        this._getTipman().show({
            owner: this,
            content: text
        });

        this.setMod('error', 'yes');
    },

    /**
     * Скрывает попап ошибки
     */
    hidePopup: function() {
        this._getTipman().hide();
    },

    /**
     * Убирает ошибку c поля
     */
    clearError: function() {
        this.delMod('error');
    },

    destruct: function() {
        this._tipman && this._tipman.destruct();
        this._input && this._input.destruct();  // Падают тесты из-за вызова события 'blur' на несуществующем 'input'
        this.__base.apply(this, arguments);
    }

}, {
    live: function() {
        this
            .liveBindTo('input', 'keydown', function(e) {
                this._onInputKeyDown(e);
            })
            .liveInitOnBlockInsideEvent('blur', 'input', function() {
                this._onInputBlur();
            })
            .liveInitOnBlockInsideEvent('change', 'input', function() {
                this._onInputChange();
            })
            .liveInitOnBlockInsideEvent('click', 'button2', function() {
                this._onLabelClick();
            });
    }
});
