block('b-email-notification').elem('interval').content()(function() {
    var warning = this.ctx.warning,
        sendWarn = warning.sendWarn;

    return [
        {
            elem: 'control',
            mix: [{
                block: 'b-email-notification', elem: 'interval-toggle', elemMods: { collapsed: sendWarn ? 'no' : 'yes' }
            }],
            content: [
                {
                    block: 'checkbox',
                    mods: {
                        checked: sendWarn ? 'yes' : ''
                    },
                    mix: [
                        { block: 'b-email-notification', elem: 'send-warn' },
                        {
                            block: 'b-email-notification',
                            elem: 'model-field',
                            js: { type: 'checkbox', name: 'sendWarn' }
                        }
                    ],
                    checkboxAttrs: { value: sendWarn },
                    text: iget2('b-email-notification', 'change-traffic-volume', 'Изменение объёма трафика')
                },
                {
                    elem: 'collapsing-area',
                    content: [
                        '&nbsp;–&nbsp;',
                        iget2('b-email-notification', 'uvedomlyat-kazhdye-x-minut', 'уведомлять каждые {select} минут', {
                            select: {
                                block: 'select',
                                mix: [
                                    {
                                        block: 'b-email-notification',
                                        elem: 'warn-interval'
                                    }, {
                                        block: 'b-email-notification',
                                        elem: 'model-field',
                                        js: {
                                            type: 'select',
                                            name: 'warnPlaceInterval'
                                        }
                                    }
                                ],
                                mods: { disabled: sendWarn ? '' : 'yes' },
                                content: [
                                    {
                                        block: 'button',
                                        content: warning.interval
                                    },
                                    {
                                        elem: 'control',
                                        content: [15, 30, 60].map(function(interval) {
                                            var isSelected = warning.interval === interval,
                                                attrs = { value: interval };

                                            isSelected && (attrs.selected = 'selected');

                                            return {
                                                elem: 'option',
                                                attrs: attrs,
                                                content: interval
                                            };
                                        })
                                    }
                                ]
                            }
                        })
                    ]
                }
            ]
        },
        {
            elem: 'info',
            content: iget2(
                'b-email-notification',
                'preduprezhdeniya-o-smene-pozicii2',
                'Предупреждения об изменении объёма трафика не отправляются, если в кампании настроена почасовая корректировка ставок'
            )
        }
    ];
});
