block('b-email-notification').mod('extended', 'yes')(
    js()(function() {
        return { modelData: this.ctx.options };
    }),

    content()(function() {
        var options = this.ctx.options,
            campaign = options.campaign,
            mediaType = campaign.mediaType,
            wallet = options.wallet,
            warning = options.warning,
            client = options.client,
            servicing = options.servicing;

        return [
            {
                block: 'b-email-notification',
                elem: 'email',
                emailSelect: this.ctx.emailSelect
            },
            {
                block: 'b-email-notification',
                elem: 'subscription',
                content: iget2('b-email-notification', 'o-kakih-sobytiyah-uvedomlyat', 'О каких событиях уведомлять')
            },
            // DIRECT-36537 — Не показывать настройку уведомлений остатка средств на кампаниях при подключенном о.с.
            !+wallet.cid && !+wallet.willBeEnabled && {
                block: 'b-email-notification',
                elem: 'warning-value',
                mix: [{ block: 'b-email-notification', elem: 'row' }],
                warning: warning
            },

            (!mediaType ||
                (!u._.contains(['mcbanner', 'cpm_banner', 'cpm_deals', 'cpm_yndx_frontpage', 'content_promotion'], mediaType))) && {
                    block: 'b-email-notification',
                    elem: 'interval',
                    mix: [{ block: 'b-email-notification', elem: 'row' }],
                    warning: warning
                },
            (client && client.can_use_day_budget) && {
                block: 'b-email-notification',
                elem: 'day-budget-stop',
                mix: [{ block: 'b-email-notification', elem: 'row' }],
                checked: warning.isPaused
            },
            (servicing.ManagerUID || servicing.request) && {
                block: 'b-email-notification',
                elem: 'servicing',
                mix: [{ block: 'b-email-notification', elem: 'row' }],
                servicing: servicing
            },
            mediaType !== 'content_promotion' && {
                block: 'b-email-notification',
                elem: 'xls-ready',
                mix: [{ block: 'b-email-notification', elem: 'row' }],
                offlineStatNotice: servicing.offlineStatNotice
            }
        ];
    })
);
