BEM.DOM.decl({ name: 'b-email-notification', modName: 'extended', modVal: 'yes' }, {

    onSetMod: {
        js: function() {
            var modelData = this.params.modelData;

            this.__base.apply(this, arguments);
            this._update(modelData);

            this._subMan = BEM.create('i-subscription-manager');
            u.graspSelf.call(this, {
                _select: 'b-email-select inside',
                _warnCheckbox: '? checkbox on send-warn',
                _warnInterval: '? select on warn-interval',
                _pause: '? checkbox on pause',
                _servicing: '? checkbox on servicing',
                _xls: '? checkbox on xls-ready',
                _email: '? input on email-input'
            });

            this._subMan
                .on(this._select, 'change', function(e, data) {
                    this.model.set('email', data.val, { source: this });
                }, this)
                .on(this.elem('show-all-email'), 'click', this._onShowAllEmailsLinkClick.bind(this));

            this._warnCheckbox && this._subMan
                .on(this._warnCheckbox, 'change', function(e, data) {
                    var warnEnabled = data.checked;

                    this._warnInterval.toggleMod('disabled', '', 'yes', warnEnabled);

                    this.toggleMod(this.elem('interval-toggle'), 'collapsed', 'no', 'yes', warnEnabled);
                }, this);

            this._email && this._subMan
                .on(this._email, 'change', function() {
                    this.findElem('warning-value-error').text('');
                }, this);

            this._subMan.wrap(this.model)
                .on('money_warning_value', 'error', this._showMoneyWarningValueError, this);

            this.model.fix();
        }
    },

    /**
     * Получение данных о состоянии модели
     * @returns {Boolean}
     */
    isChanged: function() {
        return this.model.isChanged();
    },

    /**
     * Получение данных модели
     * @returns {json}
     */
    getData: function() {
        return this.model.toJSON();
    },

    /**
     * Обновление модели
     * @param {Object} data
     */
    update: function(data) {
        !!data && this._update(data);
    },

    /**
     * Деструктор
     */
    destruct: function() {
        this._subMan.dispose();
        this._subMan.destruct();

        this.__base.apply(this);
    },

    /**
     * Валидация модели: реализация интерфейса
     * @returns {Boolean}
     */
    validate: function() {
        this.model.validate();
        return this.model.isValid();
    },

    /**
     * откат модели к фиксированным значениям
     */
    reset: function() {
        this.model.rollback();
    },

    /**
     * Обновление модели
     * @param {Object} modelData
     * @private
     */
    _update: function(modelData) {
        this.model.update({
            email: modelData.email,
            sendWarn: !!+modelData.warning.sendWarn,
            sendAccNews: !!+modelData.servicing.sendAccNews,
            money_warning_value: modelData.warning.value,
            warnPlaceInterval: modelData.warning.interval,
            offlineStatNotice: !!+modelData.servicing.offlineStatNotice,
            pausedByDayBudgetCheckboxState: !!modelData.warning.isPaused
        }).fix();
    },

    /**
     * Обработчик ошибки поля модели money_warning_value
     * @param {Event} e событие
     * @param {Object} error ошибка
     * @private
     */
    _showMoneyWarningValueError: function(e, error) {
        this.elem('warning-value-error').text(error.text);
    },

    /**
     * Обработчик клика на ссылку "показать все адреса"
     * @param {Event} e событие
     * @private
     */
    _onShowAllEmailsLinkClick: function(e) {
        e.preventDefault();

        window.open($(e.target).attr('href'), 'email', 'width=700,height=450,scrollbars=1');
    }
});
