block('b-email-notification')(
    js()(function() {
        var opt = this.ctx.options;

        return {
            modelData: u._.assign(
                {
                    email_notify_paused_by_day_budget: opt.email_notifications.paused_by_day_budget ? 1 : 0,
                    pausedByDayBudgetCheckboxState: !!opt.email_notifications.paused_by_day_budget
                },
                opt,
                opt.email_notifications
            )
        };
    }),

    content()(function() {
        var ctx = this.ctx,
            emailSelect = ctx.emailSelect;

        return {
            block: 'b-layout-form',
            mods: {
                inner: 'yes'
            },
            mix: { block: 'b-email-notification', elem: 'wallet' },
            mixes: {
                row: [
                    {
                        block: 'b-email-notification',
                        elem: 'row'
                    },
                    {
                        block: 'b-email-notification',
                        elem: 'row-container'
                    }
                ],
                label: [
                    {
                        block: 'b-email-notification',
                        elem: 'label'
                    }
                ],
                control: [
                    {
                        block: 'b-email-notification',
                        elem: 'control'
                    },
                    {
                        block: 'b-email-notification',
                        elem: 'control-wallet'
                    }
                ],
                info: [{
                    block: 'b-email-notification',
                    elem: 'info'
                }]
            },
            rows: [
                {
                    label: iget2('b-email-notification', 'el-pochta', 'Эл. почта'),
                    control: emailSelect
                },
                {
                    label: iget2('b-email-notification', 'uvedomleniya', 'Уведомления'),
                    control: {
                        block: 'b-email-notification',
                        elem: 'day-budget-stop',
                        checked: ctx.options.email_notifications.paused_by_day_budget
                    }
                }
            ]
        };
    })
);
