u.register({

    'b-email-notification': {

        /**
         * Формирует настройки уведомлений
         * @param {Object} campaign - кампания
         * @param {Object} data - данные сервера
         * @returns {Object}
         */
        formData: function(campaign, data) {
            return {
                campaign: {
                    cid: campaign.cid,
                    isCampaign: campaign.isCampaign,
                    mediaType: campaign.mediaType
                },
                user: {
                    login: data.user_login,
                    script: data.SCRIPT
                },
                client: data.client,
                wallet: {
                    cid: campaign.wallet_cid,
                    willBeEnabled: campaign.wallet_will_be_enabled
                },
                warning: {
                    value: campaign.money_warning_value,
                    sendWarn: campaign.sendWarn,
                    interval: campaign.warnPlaceInterval,
                    isPaused: campaign.email_notify_paused_by_day_budget
                },
                servicing: {
                    ManagerUID: campaign.ManagerUID,
                    request: campaign.servicing_request,
                    sendAccNews: campaign.sendAccNews,
                    offlineStatNotice: campaign.offlineStatNotice
                },
                validEmails: data.validEmails,
                email: campaign.email,
                dmParams: campaign.dmParams
            };
        }

    }

});
